% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{LN}
\alias{LN}
\title{Estimated Density Values by Lognormal kernel}
\usage{
LN(y, k, h)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
Estimated Values of Density estimation by using Lognormal Kernel.
}
\details{
The Lognomal kernel is also developed by Jin and Kawczak (2003). For this too, they claimed that performance of their developed kernel is better near the
boundary points in terms of boundary reduction.
Lognormal Kernel is
\deqn{K_{LN(\ln(x),4\ln(1+h))}=\frac{1}{\sqrt{( 8\pi \ln(1+h))} y)} exp\left[-\frac{(\ln(y)-\ln(x))^2}{(8\ln(1+h))}\right]}
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
LN(y,200,h)
}
\references{
Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103–124.
}
\seealso{
For further kernels see \code{\link{Erlang}}, \code{\link{Gamma}} and \code{\link{BS}}. To plot its density see \code{\link{plot.LN}} and to calculate MSE by using Lognormal Kernel \code{\link{mseLN}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
