% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter-methods.R
\name{read.DeponsParam}
\alias{read.DeponsParam}
\title{Read simulation parameters}
\usage{
read.DeponsParam(fname)
}
\arguments{
\item{fname}{Name of the XML file (character) that contains the parameter
list used for running a DEPONS simulation. The name includes the path to the
directory if this is not the current working directory.}
}
\value{
Data frame containing all parameters used in a specific
simulation
}
\description{
Read the parameters that were used for running a specific DEPONS
simulation
}
\details{
The parameter file can be generated from within DEPONS by pressing the
'Save' icon after modifying the user settings on the 'Parameters' tab within
the main DEPONS model window. See TRACE document for details regarding the
parameters in the model: \url{https://github.com/jacobnabe/DEPONS}. It is strongly recommended that the parameter
list is stored with the simulation output.
}
\examples{
\dontrun{
# Parameters read from file created by DEPONS run in interactive mode
the.file <- "/Applications/DEPONS 2.1/DEPONS/DEPONS.rs/parameters.xml"
pfile <- read.DeponsParam(the.file)
}
}
