% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-methods.R
\name{plot,DeponsTrack,missing-method}
\alias{plot,DeponsTrack,missing-method}
\alias{plot.DeponsTrack}
\title{Plot a DeponsTrack object}
\usage{
\S4method{plot}{DeponsTrack,missing}(x, y, trackToPlot = 1, add = FALSE, ...)
}
\arguments{
\item{x}{DeponsTrack object}

\item{y}{Not used}

\item{trackToPlot}{Integer; indicates which track to plot if there is more
than one track in the object. Defaults to 1}

\item{add}{Logical, whether to add the track to an existing plot
one animal was tracked during the simulation.}

\item{...}{Optional plotting parameters}
}
\value{
No return value, called for side effects
}
\description{
Plot the coordinates in a movement track simulated with DEPONS.
}
\examples{
data(porpoisetrack)
data("porpoisetrack")
plot(porpoisetrack)

\donttest{
data(coastline)
data(bathymetry)
coastline2 <- sp::spTransform(coastline, crs(bathymetry))

data(porpoisetrack)
bbox <- bbox(porpoisetrack)
clip.poly <- make.clip.poly(bbox, crs(bathymetry))
if(!identical(crs(bathymetry), crs(coastline2))) stop("Non-matching CRSs")
new.coastline <- rgeos::gIntersection(coastline2, clip.poly, byid = TRUE,
    drop_lower_td = TRUE)

plot(new.coastline, col="lightyellow2")
plot(porpoisetrack, col="blue", add=TRUE)
plot(clip.poly, add=TRUE)
# Clip to zoom in on smaller region
bbox <- cbind("min"=c(549517, 6155000), "max"=c(636000, 6210000))
rownames(bbox) <- c("x", "y")
clip.poly <- make.clip.poly(bbox, crs(bathymetry))
new.coastline <- rgeos::gIntersection(coastline2, clip.poly, byid = TRUE,
                                      drop_lower_td = TRUE)
plot(new.coastline, col="lightyellow2")
plot(porpoisetrack, col="blue", add=TRUE)
}
}
