% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyn-methods.R
\name{read.DeponsDyn}
\alias{read.DeponsDyn}
\title{Reading DEPONS simulation output}
\usage{
read.DeponsDyn(
  fname,
  title = "NA",
  landscape = "NA",
  simtime = "NA",
  startday = "NA",
  timestep = 30,
  tz = "GMT"
)
}
\arguments{
\item{fname}{Name of the file (character) that contains number of
animals for each time step during the simulation, along with their energy and
the amount of food in the landscape. The name includes the path to the directory
if this is not the current working directory.}

\item{title}{Optional character string giving name of simulation}

\item{landscape}{The landscape used in the simulation}

\item{simtime}{Optional character string with the date and time when the
simulation finished (format yyyy-mm-dd). If not provided this is obtained
from name of input file}

\item{startday}{The start of the period that the  simulation represents, i.e.
the real-world equivalent of 'tick 1' (character string of the
form 'yyyy-mm-dd', or POSIXlt)}

\item{timestep}{Time step used in the model, in minutes. Defaults to 30 in
DEPONS.}

\item{tz}{Time zone.}
}
\value{
\code{DeponsDyn} object containing simulation output
}
\description{
Function  for reading simulation output produced by DEPONS.
}
\examples{
\dontrun{
dyn.file <- "/Applications/DEPONS 2.1/DEPONS/Statistics.2020.Sep.02.20_24_17.csv"
file.exists(dyn.file)
porpoisedyn <- read.DeponsDyn(dyn.file, startday=as.POSIXlt("2010-01-01"))
porpoisedyn
}
}
\seealso{
See \code{\link{DeponsDyn-class}} for details on what is stored in
the output object and \code{\link{as.data.frame}} for converting from data
frame.
}
