% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{enrich_res}
\alias{enrich_res}
\title{Incorporate additional data about differentially expressed genes into a DESeq2 result set.}
\usage{
enrich_res(res)
}
\arguments{
\item{res}{A DESeq2 result set as generated through DESeq2::results().  Must be a DESeq object of type S4.}
}
\value{
An expanded DESeq result set of type DESeqResMeta containing the following fields:
[numDE, numUp, numDown, allNames, upNames, and downNames, allDE, upDE, downDE, case, control, contrast, and designField]
}
\description{
Given a DESeq result set, as generated with DESeq2::results(), this function adds several additional components to the object.
Variables created are numDE, numUp, numDown, allNames, upNames, and downNames, allDE, upDE, downDE, case, control, contrast, and designField.
All calculations are performed based on significance thresholds set using the init_cutoffs() function.
This function is typically used as a helper function for data aggregation.
}
\examples{
\dontrun{

#Enrich a result set. This will make several new data points available.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
enriched_result <- enrich_res(res.day1)

#Print number of differentially expressed genes.
print(enriched_result@numDE)

#Get the names of all up-regulated differentially expressed genes.
upreg_de_genes <- enriched_result@upNames
}
}
\seealso{
\code{\link{init_cutoffs}}
}
\keyword{DE}
\keyword{aggregate}
