% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dir_control.R
\name{init_data_paths}
\alias{init_data_paths}
\title{Initialize data paths for count and target files.}
\usage{
init_data_paths(count_path, target_path)
}
\arguments{
\item{count_path}{Path to directory containing count data. Count data is assumed to be tab-delimited text
represent raw expression counts for each gene, with samples indicated by column and genes identified by row.
Column names in count data must correspond to row names in target files.}

\item{target_path}{Path to directory containing target data. Target data can be tab-delimited or comma-separated text.
Target rownames must correspond to count column names.  Additionally, any data can be included in target files to
represent experimental conditions or additional metadata for the project.}
}
\value{
This function does not return a value.
}
\description{
This function initializes the paths to folders containing count and target data.  This package
assumes correspondence between count data column names and target data row names.  In this package,
metadata files are referred to as target data.
Initialization by this function is required by most functions.
}
\examples{
\dontrun{

#Initialize paths to count and target file directories.
init_data_paths(count_path="/Users/adam/projects/ebola/counts/",
                target_path="/Users/adam/projects/ebola/")

}
}
\seealso{
\code{\link{create_dir_struct}}
}
\keyword{directory}
\keyword{initialization}
\keyword{input}
\keyword{organization}
\keyword{project-management}
