% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCor.R
\name{dCorrs}
\alias{dCorrs}
\title{Differential correlation between two conditions.}
\usage{
dCorrs(rho1, n1, rho2, n2, corrType = "pearson")
}
\arguments{
\item{rho1}{Numeric vector of correlation coefficients in condition 1.}

\item{n1}{Numeric vector of the number of samples used in the correlation calculations in condition 1.}

\item{rho2}{Numeric vector of correlation coefficients in condition 2.}

\item{n2}{Numeric vector of the number of samples used in the correlation calculations in condition 2.}

\item{corrType}{The correlation type of the analysis, limited to "pearson" or "spearman".}
}
\value{
Numeric vector with scaled difference in z-scores of correlations between the two conditions.
}
\description{
Z-transforms correlation coefficients (Pearson or Spearman) and then calculates the difference in z-scores between the two conditions divided by the square root of the standard errors (which is inversely proportion to the sample sizes used to calculate the correlations).
}
\examples{
rho1 = runif(100, -1, 1); rho2 = runif(100, -1, 1)
n1 = rep(100, 100); n2 = rep(110, 100)
dcorrs_res = dCorrs(rho1, n1, rho2, n2)
}
\references{
Tests For Rank Correlation Coefficients, I. http://biomet.oxfordjournals.org/content/44/3-4/470.full.pdf+html
}

