% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plots}
\alias{plots}
\alias{plot.glm_hP}
\alias{plot.glm_CMP}
\title{Plot Diagnostics for glm_hP and glm_CMP Objects}
\usage{
\method{plot}{glm_hP}(
  x,
  type = c("quantile", "pearson", "response"),
  ask = prod(graphics::par("mfcol")) < 2 && grDevices::dev.interactive(),
  ...
)

\method{plot}{glm_CMP}(
  x,
  type = c("quantile", "pearson", "response"),
  ask = prod(graphics::par("mfcol")) < 2 && grDevices::dev.interactive(),
  ...
)
}
\arguments{
\item{x}{\code{glm_hP} or \code{glm_CMP} object, typically the result of
\code{\link{glm.hP}} or \code{\link{glm.CMP}}.}

\item{type}{the type of residuals. The alternatives are: "quantile"
(default), "pearson" and "response". Can be abbreviated.}

\item{ask}{logical; if TRUE, the user is asked before each plot, see
\code{\link[graphics]{par}}(ask=.).}

\item{...}{other parameters to be passed through to plotting functions.}
}
\description{
Two plots are currently available: a plot of residuals against fitted values
and a Normal Q-Q plot.
}
\examples{
## Fit the hyper-Poisson model
Bids$size.sq <- Bids$size ^ 2
hP.fit <- glm.hP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.gamma = numbids ~ 1, data = Bids)
oldpar <- par(mfrow = c(1, 2))

## Plot diagnostics

plot(hP.fit)
par(oldpar)
## Fit the COM-Poisson model
Bids$size.sq <- Bids$size ^ 2
CMP.fit <- glm.CMP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.nu = numbids ~ 1, data = Bids)
oldpar <- par(mfrow = c(1, 2))

## Plot diagnostics
plot(CMP.fit)
par(oldpar)
}
