% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_if_unique_rows.R
\name{check_if_unique_rows}
\alias{check_if_unique_rows}
\title{Takes a data.table dataset and checks if for each unique
  element in a specified column there is exaclty one row.}
\usage{
check_if_unique_rows(
  data,
  colname,
  findme = NULL,
  stop = FALSE,
  feedback = TRUE,
  print_invalid_rows = TRUE,
  return = TRUE
)
}
\arguments{
\item{data}{A data.table}

\item{colname}{The name of the column to check for uniqueness.}

\item{findme}{(Optional, String, default: "")
Recommended with length 10.
String to find the message in the code.
E.g. 10-digit random hex from
\url{https://onlinerandomtools.com/generate-random-hexadecimal-numbers}}

\item{stop}{(boolean, default = FALSE) Should the function call
\code{stop()} if there are non-unique rows in the data?}

\item{feedback}{(boolean, default = TRUE) Should the function print
text to the console depending on the result?}

\item{print_invalid_rows}{(boolean, default = TRUE) Should the function
print invalid rows to the console?}

\item{return}{(boolean, default = TRUE) Should the function return `TRUE`
or `FALSE` depending on the result? If `stop = TRUE` is set, the function
will end with `stop()` before returning anything.}
}
\description{
Takes a data.table dataset and checks if for each unique
  element in a specified column there is exaclty one row.
}
\examples{
\dontrun{
  check_if_unique_rows(data)
}

}
