% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.r
\name{SetRecruitCycle}
\alias{SetRecruitCycle}
\title{Function to calculate cyclic recruitment pattern given user-specified values
of period and amplitude.}
\usage{
SetRecruitCycle(x=1, Period, Amplitude, TotYears, Shape=c('sin',
'shift'))
}
\arguments{
\item{x}{Simulation number.}

\item{Period}{A vector of length 2 specifying the minimum and maximum values
for the period of the recruitment cycles. e.g., if Period = c(10,10), then
recruitment cycle occurs every 10 years exactly.}

\item{Amplitude}{A vector of length 2 specifying the minimum and maximum
values for the amplitude of the recruitment cycles. e.g., if Amplitude =
c(0,0.5), the average recruitment will increase (or decrease) by a factor
between 0 and 0.5 each cycle.}

\item{TotYears}{A numeric value specifying the total number of years (should
be nyears + proyears).}

\item{Shape}{Specifies whether cyclic recruitment pattern is sine wave
(default) or a step-change (shift).}
}
\description{
Calculates cyclic pattern in recruitment deviations for a simulation. Ranges
for Period and Amplitude are specified by user, and function produces cyclic
pattern from within these ranges. Default is a sine wave.
}
\author{
A. Hordyk
}
