% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSEObj.r
\name{VOIplot}
\alias{VOIplot}
\title{Yet another Value of Information Plot}
\usage{
VOIplot(MSEobj, MPs=NA, nvars=5, nMP=4, Par=c('Obs', 'OM'),
YVar=c('Y', 'B'), doPlot=TRUE, incStat=FALSE, availMP=NULL, acceptMP=NULL,
incNames=TRUE, labcex=0.8, quants=c(0.05, 0.95))
}
\arguments{
\item{MSEobj}{An object of class MSE}

\item{MPs}{The MPs to plot. If NA it will plot the first nMP from MSEobj}

\item{nvars}{The number of observation or operating model parameters to plot
(number of columns)}

\item{nMP}{The maximum number of MPs to plot (number of rows)}

\item{Par}{Plot Operating Model (OM) or Observation (Obs) parameters?}

\item{YVar}{Variable for Y-Axis: Yield (Y) or Biomass (B) (relative to BMSY)}

\item{doPlot}{Output the plot?}

\item{incStat}{Include a print out of statistic describing the curviness of
the line?}

\item{availMP}{Optional character string of MPs that are available. These
names are colored black}

\item{acceptMP}{Optional character string of MPs that are acceptable. These
names are colored green if they are also in availMP}

\item{incNames}{Include the names?}

\item{labcex}{Character size of the label}

\item{quants}{Quantiles to calculate}
}
\value{
A list of all the information included in the plot
}
\description{
A function that relates parameters of the observation model and the
operating model parameters to yield.
}
\author{
A. Hordyk
}
