% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Output.r
\name{DCAC4010}
\alias{DCAC4010}
\title{Depletion Corrected Average Catch paired with the 40-10 rule}
\usage{
DCAC4010(x, Data, reps = 100)
}
\arguments{
\item{x}{A position in a data-limited methods data object}

\item{Data}{A data-limited methods data object}

\item{reps}{The number of stochastic samples of the TAC recommendation}
}
\description{
A method of calculating an MSY proxy (FMSY * BMSY and therefore the OFL at
most productive stock size) based on average catches accounting for the
windfall catch that got the stock down to BMSY levels. In this method DCAC
is paired with the 40-10 rule that throttles back the OFL to zero at 10
percent of unfished stock size (the OFL is not subject to downward
adjustment above 40 percent unfished)
}
\note{
DCAC can overfish below BMSY levels. The 40-10 harvest control rule
largely resolves this problem providing an MP with surprisingly good
performance even at low stock levels.
}
\references{
MacCall, A.D., 2009. Depletion-corrected average catch: a simple
formula for estimating sustainable yields in data-poor situations. ICES J.
Mar. Sci. 66, 2267-2271.
}
\author{
T. Carruthers
}
