% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blow_funcs.R
\name{Blow_opt}
\alias{Blow_opt}
\title{Blow internal parallel optimization function}
\usage{
Blow_opt(lnq, SSBMSYc, MGThorizon, Fc, Perrc, Mc, hc, Mac, Wac, R0c, Vc, nyears,
  maxage, movc, Spat_targc, SRrelc, aRc, bRc, Bfrac, mode = 1)
}
\arguments{
\item{lnq}{number: estimate of log catchability}

\item{SSBMSYc}{number: spawning biomass at MSY}

\item{MGThorizon}{number: MGT x HZN}

\item{Fc}{vector nyears long of fishing mortality rate}

\item{Perrc}{vector nyears+maxage-1 long of recruitment devitions}

\item{Mc}{matrix maxage by nyears+proyears of natural mortality rate}

\item{hc}{number: steepness values}

\item{Mac}{matrix nages by nyears+proyears of maturity at age}

\item{Wac}{vector nages long  of weight at age}

\item{R0c}{number: unfished recruitment}

\item{Vc}{matrix of vulnerability maxage x nyears}

\item{nyears}{integer: number of historical years}

\item{maxage}{integer: maximum age}

\item{movc}{matrix of movement 2 x 2}

\item{Spat_targc}{number: spatial targetting parameters}

\item{SRrelc}{integer representing recruitmetn dynamics type 1: Bev Holt 2: Ricker}

\item{aRc}{number: recruitment parameter}

\item{bRc}{number: recruitment parameter}

\item{Bfrac}{fraction of SSBMSY that is the target}

\item{mode}{1: find Blow 2:report blow  3:plot results}
}
\description{
Find the current biomass at which it would take HZN mean generation times
to reach Bfrac x SSBMSY biomass level given zero catches
}
\author{
T. Carruthers
}
