% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_functions.R
\name{ForceCor}
\alias{ForceCor}
\title{Forces correlation among operating model parameters for M, K, Linf and L50}
\usage{
ForceCor(OM, nsim = 48, plot = T)
}
\arguments{
\item{OM}{An operating model object with M, growth, stock-recruitment and maturity parameters specified.}

\item{nsim}{The number of simulated values to create (note that OM@nsim will be used preferentially).}

\item{plot}{Should the sampled parameters and distributions be plotted?}
}
\value{
An object of class OM with a populated (or appended) cpars slot
}
\description{
Uses typical correlations among estimated parameters to generate realistic samples for natural mortality rate (M), growth rate (K), maximum length (Linf) and length at 50% maturity (L50), these are placed in the cpars slot
}
\examples{
testOM<-ForceCor(testOM)
}
\author{
T. Carruthers (Canadian DFO grant)
}
