% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_Plotting_PMs.R
\name{VOIplot2}
\alias{VOIplot2}
\title{Value of Information Plot using PM functions}
\usage{
VOIplot2(MSE, MP = 1, type = c("Obs", "OM"), PM = "Yield", n = 5,
  axis.title.size = 12, axis.text.size = 10, legend.title.size = 10,
  include.leg = TRUE)
}
\arguments{
\item{MSE}{An object of class \code{MSE}}

\item{MP}{The name or number of MP to plot. Character or numeric.}

\item{type}{Character. Type of VOI plot - "Obs" or "OM"}

\item{PM}{Name of a \code{PM} method to plot on the y-axis}

\item{n}{The maximum number of variables to plot.}

\item{axis.title.size}{Size of axis title}

\item{axis.text.size}{Size of axis text}

\item{legend.title.size}{Size of legend text}

\item{include.leg}{Logical. Include the legend?}
}
\description{
This VOI plot shows the value of information for a single MP and uses the \code{PM}
functions.
}
\examples{
\dontrun{
MSE <- runMSE()
VOIplot2(MSE)

VOIplot2(MSE, "OM")

VOIplot2(MSE, PM='P100')

}

}
\author{
A. Hordyk
}
