% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcData.R
\name{rtDist}
\alias{rtDist}
\title{rtDist}
\usage{
rtDist(n = 10000, gaussMean = 600, gaussSD = 50, expRate = 200)
}
\arguments{
\item{n}{Number of observations}

\item{gaussMean}{Mean of the gaussian distribution}

\item{gaussSD}{SD of the gaussian distribution}

\item{expRate}{Rate of the exponential function}
}
\value{
double
}
\description{
Returns value(s) from a distribution appropriate to simulate reaction times.
The distribution is a combined exponential and gaussian distribution called
an exponentially modified Gaussian (EMG) distribution or ex-gaussian distribution.
}
\examples{
# Example 1
x <- rtDist()
hist(x, 100)

# Example 2
x <- rtDist(n=20000, gaussMean=800, gaussSD=50, expRate=100)
hist(x, 100)

}
