% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{mean.dmcfit}
\alias{mean.dmcfit}
\title{mean.dmcfit: Return mean simulation results from dmcFitSubject}
\usage{
\method{mean}{dmcfit}(x, ...)
}
\arguments{
\item{x}{Output from dmcFitSubject/dmcFitSubjectDE}

\item{...}{pars}
}
\value{
dmcfit

The function returns a list with the relevant aggregated results from dmcFitSubject/dmcFitSubjectDE. The list
is accessed with obj$name and so on with the the following:
\item{obj$means}{means}
\item{obj$delta}{delta}
\item{obj$caf}{caf}
\item{obj$prms}{par}
}
\description{
Aggregate simulation results from dmcFitSubject/dmcFitSubjectDE.
}
\examples{
\donttest{
# Example 1: Fit individual data then aggregate
fitSubjects <- dmcFitSubject(flankerData, nTrl = 1000, subjects = c(1, 2))
plot(fitSubjects, flankerData, subject = 1)
summary(fitSubjects)
fitAgg <- mean(fitSubjects)
plot(fitAgg, flankerData)
}

}
