% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lrdist_cdf.R
\name{dist.pair.cdf}
\alias{dist.pair.cdf}
\title{CDF of product of a pair of distributions (one cumulative)}
\usage{
dist.pair.cdf(pair)
}
\arguments{
\item{pair}{a list with named sublists:
\itemize{
 \item cumdist1: a list with vectors \code{x}, \code{Fx}
 \item dist2: a list with vectors \code{x}, \code{fx}
}}
}
\value{
function
}
\description{
CDF of product of a pair of distributions (one cumulative)
}
\details{
TODO
}
\examples{
data(freqsNLngm)

set.seed(123)
x <- sample.profiles(1,freqsNLngm)

# per locus distribution of kinship index
dists <- ki.dist(x,hyp.1="FS",hyp.2="UN",hyp.true="UN")

n <- sapply(dists,function(x) length(x$fx))
prod(n) # too many outcomes to store!
# but, for two subsets of the loci, the distribution can be obtained
pair <- dists.product.pair(dists)
str(pair) # with these, we can compute exceedance probabilities quickly

# obtain the cdf as a function
cdf <- dist.pair.cdf(pair)
cdf(1)

# plot the cdf
x0 <- seq(from=-10,to=5,length=50)
plot(x0,cdf(10^x0),type="l",xlab="x",ylab="Fn(x)")
}

