% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/write.genepop.R
\name{write.genepop}
\alias{write.genepop}
\title{Export to GenePop/LinkDos format}
\usage{
write.genepop(x, file = "", digits = 2L,
  description = "DNAprofiles export")
}
\arguments{
\item{x}{profiles object}

\item{file}{(optional) filename}

\item{digits}{number of digits used to encode alleles (2 or 3)}

\item{description}{first line of GenePop file}
}
\description{
Export to GenePop/LinkDos format
}
\details{
Exports a profiles object as a text file in the GenePop/LinkDos format. See http://genepop.curtin.edu.au/help_input.html for more information.
}
\examples{
data(freqsNLsgmplus)

set.seed(123)

# sample a small reference db
x <- sample.profiles(N = 1e3,freqs=freqsNLsgmplus)

write.genepop(x)
}

