% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmNoisePred.R
\name{harmNoisePred}
\alias{harmNoisePred}
\alias{harmNoisePred1}
\alias{harmNoisePred2}
\title{Asymmetric variant of Chow method applied on harmonic regression}
\usage{
harmNoisePred(val1, val2, times1, times2, period, norm = TRUE)
}
\arguments{
\item{val1}{matrix: data for values in first set. One column per
sample, one row per time point}

\item{val2}{matrix: data for values in second set. One column per
sample, one row per time point}

\item{times1}{vector: times of first set.}

\item{times2}{vector: times of second set.}

\item{period}{numeric: period of the oscillations. Same unit as the
time points in times1 and times2}

\item{norm}{boolean: whether to normalize the time series (division by mean),
prior to the analysis.}
}
\value{
list containing the fits for both time series and the combination
and the pValue for differential Oscillation
}
\description{
A harmonic regression is done on the first set of time
series (val1) pair. The differences of the second series to this fit are
calculated. By comparison of these distances with the noise estimation of
the first series, a decision is made whether the second series could be
explained as additional samples of the first series.
}

