% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{S3method.dpi}
\alias{S3method.dpi}
\alias{summary.dpi}
\alias{print.summary.dpi}
\alias{plot.dpi}
\alias{print.dpi}
\alias{plot.dpi.curve}
\title{[S3 methods] for \code{\link[=DPI]{DPI()}} and \code{\link[=DPI_curve]{DPI_curve()}}.}
\usage{
\method{summary}{dpi}(object, ...)

\method{print}{summary.dpi}(x, digits = 3, ...)

\method{plot}{dpi}(x, file = NULL, width = 6, height = 4, dpi = 500, ...)

\method{print}{dpi}(x, digits = 3, ...)

\method{plot}{dpi.curve}(x, file = NULL, width = 6, height = 4, dpi = 500, ...)
}
\arguments{
\item{object}{Object (class \code{dpi}) returned from \code{\link[=DPI]{DPI()}}.}

\item{...}{Other arguments (currently not used).}

\item{x}{Object (class \code{dpi} or \code{dpi.curve}) returned from \code{\link[=DPI]{DPI()}} or \code{\link[=DPI_curve]{DPI_curve()}}.}

\item{digits}{Number of decimal places. Defaults to \code{3}.}

\item{file}{File name of saved plot (\code{".png"} or \code{".pdf"}).}

\item{width, height}{Width and height (in inches) of saved plot.
Defaults to \code{6} and \code{4}.}

\item{dpi}{Dots per inch (figure resolution).
Defaults to \code{500}.}
}
\description{
\describe{
\item{\code{summary(dpi)}}{
Summarize DPI results.
Return a list (class \code{summary.dpi}) of summarized results and raw DPI data.frame.
}
\item{\code{print(summary.dpi)}}{
Print DPI summary.
}
\item{\code{plot(dpi)}}{
Plot DPI results.
Return a \code{ggplot} object.
}
\item{\code{print(dpi)}}{
Print DPI summary and plot.
}
\item{\code{plot(dpi.curve)}}{
Plot DPI curve analysis results.
Return a \code{ggplot} object.
}
}
}
\keyword{internal}
