% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalyticGaussianMechanismUtils.R
\name{calibrateAnalyticGaussianMechanism}
\alias{calibrateAnalyticGaussianMechanism}
\title{Calibrate Analytic Gaussian Mechanism}
\usage{
calibrateAnalyticGaussianMechanism(epsilon, delta, sensitivity, tol = 1e-12)
}
\arguments{
\item{epsilon}{Positive real number defining the epsilon privacy parameter.}

\item{delta}{Positive real number defining the delta privacy parameter.}

\item{sensitivity}{Real number corresponding to the l2-global sensitivity.}

\item{tol}{Error tolerance for binary search.}
}
\value{
Standard deviation of Gaussian noise needed to achieve
\code{(epsilon, delta)}-DP for given global sensitivity.
}
\description{
Calibrate a Gaussian perturbation for differential privacy using the analytic
Gaussian mechanism \insertCite{Balle2018}{DPpack}.
}
\references{
\insertRef{Balle2018}{DPpack}
}
\keyword{internal}
