% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_SIR_model_discrete.R
\name{simulate_SIR_model_discrete}
\alias{simulate_SIR_model_discrete}
\title{SIR model}
\usage{
simulate_SIR_model_discrete(
  S = 1000,
  I = 1,
  R = 0,
  b = 0.002,
  g = 1,
  tstart = 0,
  tfinal = 100,
  dt = 0.1
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{I}{: starting value for Infected : numeric}

\item{R}{: starting value for Recovered : numeric}

\item{b}{: infection rate : numeric}

\item{g}{: recovery rate : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A basic SIR model with 3 compartments and infection and recovery processes
}
\details{
The model includes susceptible, infected, and recovered compartments. The two processes that are modeled are infection and recovery.

This code was generated by the modelbuilder R package.  
The model is implemented as a set of discrete time equations using a for loop. 
The following R packages need to be loaded for the function to work: none
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel
}

\section{Model creation date}{
 2020-09-01
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2021-07-19
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_SIR_model_discrete() 
# To choose values other than the standard one, specify them like this:  
result <- simulate_SIR_model_discrete(S = 2000,I = 2,R = 0) 
# You can display or further process the result, like this:  
plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Numbers',type='l') 
print(paste('Max number of S: ',max(result$ts[,'S']))) 
}
