% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_drugresistance.r
\name{simulate_drugresistance}
\alias{simulate_drugresistance}
\title{Stochastic simulation of a compartmental acute virus infection model
with treatment and drug resistant strain}
\usage{
simulate_drugresistance(U0 = 1e+05, Is0 = 0, Ir0 = 0, Vs0 = 10,
  Vr0 = 0, tmax = 100, b = 1e-05, dI = 1, e = 0, m = 1e-04,
  p = 100, c = 4, f = 0.1, rngseed = 100)
}
\arguments{
\item{U0}{initial number of target cells}

\item{Is0}{initial number of wild-type infected cells}

\item{Ir0}{initial number of resistant infected cells}

\item{Vs0}{initial number of wild-type virus}

\item{Vr0}{initial number of resistant virus}

\item{tmax}{maximum simulation time, units depend on choice of units for your
parameters}

\item{b}{level/rate of infection of cells}

\item{dI}{rate of infected cell death}

\item{e}{efficacy of drug}

\item{m}{fraction of resistant mutants created}

\item{p}{virus production rate}

\item{c}{virus removal rate}

\item{f}{fitness cost of resistant virus}

\item{rngseed}{seed for random number generator to allow reproducibility}
}
\value{
A list. The list has only one element called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other columns are the model variables.
}
\description{
Simulation of a stochastic model with the following compartments:
Uninfected target cells (U), Infected with wild-type/sensitive and untreated (Is),
infected with resistant (Ir), wild-type virus (Vs), resistant virus (Vr).
}
\details{
A compartmental ID model with several states/compartments
is simulated as a stochastic model using the adaptive tau algorithm as implemented by ssa.adaptivetau
in the adpativetau package. See the manual of this package for more details.
The function returns the time series of the simulated disease as output matrix,
with one column per compartment/variable. The first column is time.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_drugresistance()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_drugresistance(tmax = 200, e = 0.5)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"Time"],result$ts[,"Vs"],xlab='Time',ylab='Uninfected cells',type='l')
}
\references{
See the manual for the adaptivetau package for details on the algorithm.
            The implemented model is loosely based on: Handel et al 2007 PLoS Comp Bio
           "Neuraminidase Inhibitor Resistance in Influenza: Assessing the Danger of Its
           Generation and Spread"
}
\author{
Andreas Handel
}
