% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_modelsettings.R
\name{generate_modelsettings}
\alias{generate_modelsettings}
\title{A function to parse modelsettings for simulation runs}
\usage{
generate_modelsettings(app_input, appsettings, appNames)
}
\arguments{
\item{app_input}{a list of shiny GUI input}

\item{appsettings}{current appsettings}

\item{appNames}{character vector of app names, available in shiny server global environment upon app initialization}
}
\value{
modelsettings a list with model settings. List elements are: \cr
modelsettings$apptitle - The name of the app that's being run.  \cr
modelsettings$simfunction - name of simulation function(s) as string.  \cr
modelsettings$simfunction2 - name of simulation function(s) as string.  \cr
modelsettings$is_mbmodel - indicate of simulation function has mbmodel structure
modelsettings$modeltype - specify what kind of model should be run.
Currently one of: _ode_, _discrete_, _stochastic_, _usanalysis_, _modelexploration_, _fit_. \cr
For more than one model type, place _and_ between them. \cr
modelsettings$plottype - 'Boxplot' or 'Scatterplot' , required for US app \cr
Optinal list elements are: \cr
List elements with names and values for inputs expected by simulation function.
If not provided, defaults of simulator function are used.\cr
modelsettings$plotscale - indicate which axis should be on a log scale (x, y or both).
If not provided or set to '', no log scales are used. \cr
modelsettings$nplots -  indicate number of plots that should be produced (number of top list elements in result).
If not provided, a single plot is assumed.  \cr
modelsettings$nreps - required for stochastic models to indicate numer of repeat simulations.
If not provided, a single run will be done. \cr
}
\description{
This function parses the shiny UI and gets input settings
and combines those with other settings for a full definition of the model and
settings that should be executed. This is a helper function.
}
\details{
This function returns specific settings for simulation runs as a list.
}
