% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSLoginBuilder.R
\name{newDSLoginBuilder}
\alias{newDSLoginBuilder}
\title{Create a new DataSHIELD login details builder}
\usage{
newDSLoginBuilder(logins = NULL, .silent = FALSE)
}
\arguments{
\item{logins}{A valid login details data frame to initiate the builder, optional.}

\item{.silent}{Do not warn user when non secure HTTP urls are encountered. Default is FALSE.}
}
\description{
Shortcut function to create a new \link{DSLoginBuilder} instance. The data frame that is being
built can be used to perform \code{\link{datashield.login}}.
}
\examples{
{
  builder <- newDSLoginBuilder()
  builder$append(server="server1", url="https://opal-demo.obiba.org", table="datashield.CNSIM1",
    user="administrator", password="password")
  builder$append(server="server2", url="dslite.server", table="CNSIM2")
  builder$append(server="server3", url="http://molgenis.example.org", table="CNSIM3",
   token="123456789")
  builder$append(server="server4", url="dslite.server", table="CNSIM4")
  logindata <- builder$build()
}
}
