% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_casupro_eco.R
\name{read_casupro_eco}
\alias{read_casupro_eco}
\title{Reads parameters from a single DSSAT CASUPRO ecotype parameter file (*.ECO)}
\usage{
read_casupro_eco(raw_lines)
}
\value{
a tibble containing the data from the raw DSSAT file
}
\description{
Reads parameters from a single DSSAT CASUPRO ecotype parameter file (*.ECO)
}
\examples{

sample_eco <- c('CA0001  (CP 80-1743; CP 88-1762)',
'!-------------------',
'  KCAN_ECO      0.80    Superseeds KCAN from .SPE file',
'  SMAX            20    Maximum number of stalks a variety can yield per stubble or plant',
'!-------------------',
'  CAB              8    Number of leaves in spindle cluster at top of stalk ("cabbage"). ',
'  CanLmtFac    0.010    Proportion of stalk leaf area moved up each day to keep de-popula',
'  LfShdFac      0.35    Proportion of a stalks new leaf area that shades (displaces to t',
'  MINSHD        0.15    Minimum value allowed for FRSHAV (Average of daylight fraction of',
'!-------------------',
'  StkSenFrac  .00005    Threshold maintenance respiration deficit to stalk dry weight rat',
'  SENDAY        0.05    Maximum fraction of existing leaf weight which can be senesced on')

read_casupro_eco(sample_eco)
}
\keyword{internal}
