% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{Simulation-class}
\alias{Simulation-class}
\alias{plot,Simulation,ANY-method}
\alias{plot,Simulation-method}
\alias{show,Simulation-method}
\alias{summary,Simulation-method}
\title{S4 Class "Simulation"}
\usage{
\S4method{summary}{Simulation}(object, ..., na.rm = FALSE)

\S4method{show}{Simulation}(object)

\S4method{plot}{Simulation,ANY}(x, y, ...)
}
\arguments{
\item{object}{an object for which a summary is desired.}

\item{...}{additional arguments affecting the summary produced.}

\item{na.rm}{logical removes the na's}

\item{x}{the coordinates of points in the plot. Alternatively, a
      single plotting structure, function or \emph{any \R object with a
        \code{plot} method} can be provided.}

\item{y}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}
}
\description{
S4 Class "Simulation"
}
\section{Slots}{

\describe{
 \item{\code{reps}}{Object of class \code{"numeric"}; the number of
 times the simulation should be repeated.}
 \item{\code{single.transect.set}}{Object of class \code{"logical"}; if
 \code{TRUE} the same set of transects are used in each repetition.}
 \item{\code{double.observer}}{Object of class \code{"logical"}; whether
 a double observer protocol is being used. Not currently implemented.}
 \item{\code{region}}{Object of class \code{"Region"}; the survey region.}
 \item{\code{design}}{Object of class \code{"Survey.Design"}; the
 survey design.}
 \item{\code{population.description}}{Object of class \code{"Population.Description"}; the population.description.}
 \item{\code{detectability}}{Object of class \code{"Detectability"}; a
 description of the detectability of the population.}
 \item{\code{ddf.analyses}}{Object of class \code{"list"}; a list of
 objects of class DDF.Analysis. These are fitted and the one with the
 minimum criteria is selected and used in predicting N and D.}
 \item{\code{dsm.analysis}}{Object of class \code{"DSM.Analysis"}; Not
 yet implemented.}
 \item{\code{ddf.param.ests}}{Object of class \code{"array"}; stores the
 parameters associated with the detection function.}
 \item{\code{results}}{A \code{"list"}" of \code{"arrays"}; stores
 the estimated of abundance and density as well as other measures
 of interest.}
 }
}

\section{Methods}{

\describe{
 \item{\code{add.hotspot}}{\code{signature=(object = "Simulation")}: adds
 a hotspot based on a gaussian decay to the density surface.}
 \item{\code{summary}}{\code{signature=(object = "Simulation")}: produces
 a summary of the simulation and its results.}
 \item{\code{generate.population}}{\code{signature = (object =
 "Simulation")}: generates a single instance of a population.}
 \item{\code{generate.transects}}{\code{signature = (object =
 "Simulation")}: generates a single set of transects.}
 \item{\code{create.survey.results}}{\code{signature = (object =
 "Simulation")}: carries out the simulation process as far as generating
 the distance data and returns an object containing the population,
 transects and data.}
 \item{\code{run.analysis}}{\code{signature = c(object =
 "Simulation", data = "LT.Survey.Results")}: returns the ddf analysis
 results from the models in the simulation fitted to the data in the
 LT.Survey.Results object.}
 \item{\code{run.analysis}}{\code{signature = c(object =
 "Simulation", data = "DDF.Data")}: returns the ddf analysis
 results from the models in the simulation fitted to the data in the
 DDF.Data object.}
 \item{\code{run}}{\code{signature = (object = "Simulation")}: runs
 the whole simulation for the specified number of repetitions.}
}
}
\seealso{
\code{\link{make.simulation}}
}
\keyword{classes}

