% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pv.prev.R
\name{pv.prev}
\alias{pv.prev}
\title{Compute predictive values for theoretical prevalences}
\usage{
pv.prev(pi, acc)
}
\arguments{
\item{pi}{A theoretical prevalence of the disease (proportion).}

\item{acc}{An object of class `acc.1test`.}
}
\value{
A vector containing the projected values.
}
\description{
It is often of interest to estimate predictive values assuming the test were applied to a population with a different prevalence of the disease. Projected predictive values may be calculated using Bayes theorem and the relation between predictive values and diagnostic likelihood ratios can be used to derived corresponding confidence intervals.
}
\details{
Predictive values, assuming a certain prevalence of the disease, 
are derived using the relation between predictive values and diagnostic likelihood ratios:

  - PPV = 1 / (1 + (1 / pi - 1) / pDLR)
  - NPV = 1 / (1 + (1 / (1 / pi - 1)) / nDLR). 
  
See Newcombe RG (2013). Confidence Intervals for Proportions and Related Measures of Effect Size. Chapman and Hall/ CRC Biostatistics Series (chapters 12.3+5 and 14.9).

The alpha-level of (1-alpha)-confidence intervals is inherited from `acc.1test`.
}
\examples{
data(Paired1) # Hypothetical study data 
a1 <- tab.1test(d=d, y=y1, data=Paired1)
a2 <- acc.1test(a1, alpha = 0.05)
pv.prev(pi=0.2, acc=a2)
pv.prev(pi=0.5, acc=a2)

}
\seealso{
[acc.1test()]
}
