% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{getCol.DTSg}
\alias{getCol.DTSg}
\alias{getCol}
\alias{[.DTSg}
\title{Get column vector}
\usage{
\method{getCol}{DTSg}(x, col = self$cols(class = "numeric")[1L], ...)

\method{[}{DTSg}(x, ...)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (\code{getCol} S3 method only).}

\item{col}{A character string specifying a column name.}

\item{\dots}{Arguments passed on to \code{getCol} (only used by the extract
operator).}
}
\value{
Returns a vector or a \code{\link{list}} in case of a \code{\link{list}} column.
}
\description{
Returns the values of a column of a \code{\link{DTSg}} object.

The extract operator (\code{[}) acts as a shortcut for \code{getCol}.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# get the first ten values of the "flow" column
## R6 methods
x$getCol(col = "flow")[1:10]
x$`[`("flow")[1:10]

## S3 methods
getCol(x = x, col = "flow")[1:10]
x["flow"][1:10]

}
\seealso{
\code{\link{cols}}
}
