% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{nas.DTSg}
\alias{nas.DTSg}
\alias{nas}
\title{List missing values}
\usage{
\method{nas}{DTSg}(x, cols = self$cols(), ...)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{cols}{A character vector specifying the columns whose missing values
shall be listed. Another possibility is a character string containing
either comma separated column names, for example, \code{"x,y,z"}, or the start
and end column separated by a colon, for example, \code{"x:z"}.}

\item{...}{Not used (S3 method only).}
}
\value{
Returns a \code{\link[data.table:data.table]{data.table::data.table}} with five columns:
\itemize{
\item \emph{.col:} the column name
\item \emph{.group:} the ID of the missing values group within each column
\item \emph{.from:} the first timestamp of the missing values group
\item \emph{.to:} the last timestamp of the missing values group
\item \emph{.n:} the number of missing values per group
}
}
\description{
Lists the missing values of selected columns of a \code{\link{DTSg}} object with
recognised periodicity.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# list missing values
## R6 method
x$nas()

## S3 method
nas(x = x)

}
\seealso{
\code{\link{cols}}
}
