% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateDMY.R
\name{calculateDMY}
\alias{calculateDMY}
\title{Calculation of daily, monthly and annual scales}
\usage{
calculateDMY(
  data = NULL,
  col_date = NULL,
  col_sum = NULL,
  col_mean = NULL,
  n.round = 2,
  type = c("Daily", "Monthly", "Yearly")
)
}
\arguments{
\item{data}{Data frame containing the data}

\item{col_date}{String with the column of data containing the date (R default date: "\%Y-\%m-\%d")}

\item{col_sum}{String with the column of data to apply the sum process}

\item{col_mean}{String with the column of data to apply the averaging process}

\item{n.round}{Integer, number of decimal places}

\item{type}{string, receives "Daily", "Monthly" or "Yearly" ("Daily" default). Defines the scale of processing to be performed}
}
\value{
Data frame with the defined scale
}
\description{
Performs data processing on an hourly scale for daily, monthly or annual scales
}
\examples{
address <-
 base::system.file("extdata",
                    "ex1_inmet.CSV",
                    package = "DataMetProcess")

df <-
read.table(
  address,
  h=TRUE,
  sep = ";",
  dec = ",",
  skip = 8,
  na.strings = -9999,
  check.names = FALSE
)

df$Data = as.Date(df$Data,format = "\%d/\%m/\%Y")

df.d <-
  calculateDMY(
    data = df,
    col_date = "Data",
    col_sum = colnames(df)[c(3,7)],
    col_mean = colnames(df)[-c(1,2,3,7)],
    type = "Daily"
  )

df.m <-
  calculateDMY(
    data = df.d,
    col_date = "Data",
    col_sum = colnames(df.d)[c(2)],
    col_mean = colnames(df.d)[-c(1,2)],
    type = "Monthly"
  )

df.a <-
  calculateDMY(
    data = df.m,
    col_date = "Data",
    col_sum = colnames(df.m)[c(2)],
    col_mean = colnames(df.m)[-c(1,2)],
    type = "Yearly"
  )


}
