testPetrie <- function(n.iter) {
  for(i in 1:n.iter) {
    set.seed(i)
    X1 <- mvtnorm::rmvnorm(100, sigma = matrix(0.2, 10, 10) + diag(0.8, 10, 10), 
                           mean = runif(10, -2, 2))
    X2 <- mvtnorm::rmvnorm(100, mean = runif(10, -2, 2), 
                           sigma = matrix(0.5, 10, 10) + diag(0.5, 10, 10))
    X3 <- mvtnorm::rmvnorm(100, sigma = matrix(0.2, 10, 10) + diag(0.8, 10, 10), 
                           mean = runif(10, -2, 2))
    X4 <- mvtnorm::rmvnorm(100, mean = runif(10, -2, 2), 
                           sigma = matrix(0.5, 10, 10) + diag(0.5, 10, 10))
    X5 <- mvtnorm::rmvnorm(100, sigma = matrix(0.2, 10, 10) + diag(0.8, 10, 10), 
                           mean = runif(10, -2, 2))
    X6 <- mvtnorm::rmvnorm(100, mean = runif(10, -2, 2), 
                           sigma = matrix(0.5, 10, 10) + diag(0.5, 10, 10))
    set.seed(i)
    res.Petrie <- DataSimilarity::Petrie(X1, as.data.frame(X2), X3, X4, X5, X6)
    
    testthat::test_that("output type", {
      # check length and names of output
      testthat::expect_length(res.Petrie, 8)
      testthat::expect_named(res.Petrie, c("statistic", "p.value", "estimate", 
                                           "alternative", "method", "data.name", "stderr", 
                                           "mu0"))
      # check p values in [0,1]
      testthat::expect_lte(res.Petrie$p.val, 1)
      testthat::expect_gte(res.Petrie$p.val, 0)
      # statistic and p values are not NA
      testthat::expect_false(is.na(res.Petrie$statistic))
      testthat::expect_false(is.na(res.Petrie$p.val))
      # output should be numeric
      testthat::expect_s3_class(res.Petrie, "htest")
    })
    
    res.Petrie.1 <- DataSimilarity::Petrie(X1[, 1, drop = FALSE], 
                                           as.data.frame(X2)[, 1, drop = FALSE], 
                                           X3[, 1, drop = FALSE], 
                                           X4[, 1, drop = FALSE], 
                                           X5[, 1, drop = FALSE], 
                                           X6[, 1, drop = FALSE])
    testthat::test_that("output type", {
      # check length and names of output
      testthat::expect_length(res.Petrie.1, 8)
      testthat::expect_named(res.Petrie.1, c("statistic", "p.value", "estimate", 
                                           "alternative", "method", "data.name", "stderr", 
                                           "mu0"))
      # check p values in [0,1]
      testthat::expect_lte(res.Petrie.1$p.val, 1)
      testthat::expect_gte(res.Petrie.1$p.val, 0)
      # statistic and p values are not NA
      testthat::expect_false(is.na(res.Petrie.1$statistic))
      testthat::expect_false(is.na(res.Petrie.1$p.val))
      # output should be numeric
      testthat::expect_s3_class(res.Petrie.1, "htest")
    })
  }
}

set.seed(0305)
testPetrie(10)
