% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSpaceMab.R
\name{DataSpaceMab}
\alias{DataSpaceMab}
\title{The DataSpaceMab class}
\description{
The DataSpaceMab class

The DataSpaceMab class
}
\section{Constructor}{

\code{DataSpaceConnection$getMab()}
}

\examples{
\dontrun{
# Create a connection (Initiate a DataSpaceConnection object)
con <- connectDS()

# Browse the mAb Grid
con$mabGridSummary

# Filter the grid by viruses
con$filterMabGrid(using = "virus", value = c("242-14", "Q23.17", "6535.3", "BaL.26", "DJ263.8"))

# Filter the grid by donor species (llama)
con$filterMabGrid(using = "donor_species", value = "llama")

# Check the updated grid
con$mabGridSummary

# Retrieve available viruses in the filtered grid
con$mabGrid[, unique(virus)]

# Retrieve available clades for 1H9 mAb mixture in the filtered grid
con$mabGrid[mab_mixture == "1H9", unique(clade)]

# Create a DataSpaceMab object that contains the filtered mAb data
mab <- con$getMab()
mab

# Inspect the `nabMab` field
mab$nabMab
}

}
\seealso{
\code{\link{connectDS}} \code{\link{DataSpaceConnection}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{config}}{A list. Stores configuration of the connection object such
as URL, path and username.}

\item{\code{studyAndMabs}}{A data.table. The table of available mAbs by study.}

\item{\code{mabs}}{A data.table. The table of available mAbs and their
attributes.}

\item{\code{nabMab}}{A data.table. The table of mAbs and their neutralizing
measurements against viruses.}

\item{\code{studies}}{A data.table. The table of available studies.}

\item{\code{assays}}{A data.table. The table of assay status by study.}

\item{\code{variableDefinitions}}{A data.table. The table of variable
definitions.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataSpaceMab$new()}}
\item \href{#method-print}{\code{DataSpaceMab$print()}}
\item \href{#method-refresh}{\code{DataSpaceMab$refresh()}}
\item \href{#method-clone}{\code{DataSpaceMab$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize \code{DataSpaceMab} object.
See \code{\link{DataSpaceConnection}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceMab$new(mabMixture, filters, config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mabMixture}}{A character vector.}

\item{\code{filters}}{A list.}

\item{\code{config}}{A list.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the \code{DataSpaceMab} object summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceMab$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-refresh"></a>}}
\if{latex}{\out{\hypertarget{method-refresh}{}}}
\subsection{Method \code{refresh()}}{
Refresh the \code{DataSpaceMab} object to update datasets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceMab$refresh()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceMab$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
