% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbCreateTable,DatabaseConnectorConnection,character,data.frame-method}
\alias{dbCreateTable,DatabaseConnectorConnection,character,data.frame-method}
\title{Create a table in the database}
\usage{

  \S4method{dbCreateTable}{DatabaseConnectorConnection,character,data.frame}(conn,
  name, fields, oracleTempSchema = NULL, ..., row.names = NULL,
  temporary = FALSE)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{Name of the table, escaped with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[=dbDataType]{dbDataType()}}.}

\item{oracleTempSchema}{Specifically for Oracle, a schema with write priviliges where temp tables
can be created.}

\item{...}{Other arguments used by individual methods.}

\item{row.names}{Must be \code{NULL}.}

\item{temporary}{Should the table created as a temp table?}
}
\description{
The default \code{dbCreateTable()} method calls \code{\link[=sqlCreateTable]{sqlCreateTable()}} and
\code{\link[=dbExecute]{dbExecute()}}.
Backends compliant to ANSI SQL 99 don't need to override it.
Backends with a different SQL syntax can override \code{sqlCreateTable()},
backends with entirely different ways to create tables need to
override this method.
}
\details{
The \code{row.names} argument is not supported by this method.
Process the values with \code{\link[=sqlRownamesToColumn]{sqlRownamesToColumn()}} before calling this method.

The argument order is different from the \code{sqlCreateTable()} method, the
latter will be adapted in a later release of DBI.
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbAppendTable}}, \code{\link{dbDataType}},
  \code{\link{dbDisconnect}}, \code{\link{dbExecute}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbListFields}},
  \code{\link{dbListObjects}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
