% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeCAFS.R
\name{DeCAFS}
\alias{DeCAFS}
\title{Main DeCAFS function}
\usage{
DeCAFS(
  data,
  beta = 2 * log(length(data)),
  modelParam = estimateParameters(data),
  penalties = NULL,
  type = "std"
)
}
\arguments{
\item{data}{A vector of observations y}

\item{beta}{The l0 penalty. The default one is \code{2 * log(N)} where \code{N} is the length of the data.}

\item{modelParam}{A list of 3 initial model parameters: \code{sdEta}, the SD of the drift (random fluctuations) in the signal, \code{sdNu}, the SD of the AR(1) noise process, and \code{phi}, the autocorrelation parameter of the noise process. Defaulted to \code{estimateParameters(data, K = 15)}, to perform automatically estimation of the three. See \code{\link[=estimateParameters]{estimateParameters()}} for more details.}

\item{penalties}{Can be used as an alternative to the model parameters, a list of 3 initial penalties: \code{lambda} l2-penalty penalising over the lag-1 of the signal, \code{gamma}, penalising over the lag-1 of the AR(1) noise process, \code{phi}, the autocorrelation parameter. Defaulted to NULL.}

\item{type}{The type of change one wants to look for. At the moment only 'std' is implemented.}
}
\value{
Returns an s3 object of class DeCAFSout where:
\describe{
\item{\code{$changepoints}}{is the vector of change-point locations,}
\item{\code{$signal}}{is the estimated signal without the auto-correlated noise,}
\item{\code{$costFunction}}{ is the optimal cost in form of piecewise quadratics at the end of the sequence,} 
\item{\code{$estimatedParameters}}{is a list of parameters estimates (if estimated, otherwise simply the initial \code{modelParam} input),} 
\item{\code{$data}}{is the sequence of observations.}
}
}
\description{
Detecting Abrupt Changes in the Presence ofLocal Fluctuations in the signal or Autocorrelated Noise.
}
\examples{
library(ggplot2)
set.seed(42)
Y = dataRWAR(n = 1e3, poisParam = .01, meanGap = 15, phi = .5, sdEta = 1, sdNu = 3)
y = Y$y
res = DeCAFS(y)
ggplot(data.frame(t = 1:length(y), y), aes(x = t, y = y)) +
  geom_point() +
  geom_vline(xintercept = res$changepoints, color = "red") +
  geom_vline(xintercept = Y$changepoints, col = "blue",  lty = 3)
}
\references{
Romano, G., Rigaill, G., Runge, V., Fearnhead, P. Detecting Abrupt Changes in the Presence of Local Fluctuations and Autocorrelated Noise. arXiv preprint \url{https://arxiv.org/abs/2005.01379} (2020).
}
