#' @title Datasets for Testing DecomposeR
#'
#' @description Datasets for testing DecomposeR: the \code{ace} dataset is from
#' from Sinnesael et al. (2016), the \code{cip2} and \code{cip3} data sets are
#' from the signals 2 and 3 of the CIP project, respectively, and \code{cip1}
#' was derived from \code{cip1_raw} which is a rasterisation of the .tif image
#' provided as signal 1 of the CIP project.
#'
#' @references Sinnesael, M., Zivanovic, M., De Vleeschouwer,
#' D., Claeys, P. & Schoukens, J. (2016). Astronomical component
#' estimation (ACE v.1) by time-variant sinusoidal modeling. Geoscientific
#' Model Development. 9. 3517-3531.
#' \url{https://doi.org/10.5194/gmd-9-3517-2016}.
#'
#' @details
#'
#'\describe{
#'   \item{\strong{dt}}{Values of the signal}
#'   \item{\strong{xy}}{Depth or time of the signal}
#' }
#'
#' @name DecomposeR.Datasets
NULL

#' @rdname DecomposeR.Datasets
#' @name ace
NULL


#' @rdname DecomposeR.Datasets
#' @name cip1
NULL

#' @rdname DecomposeR.Datasets
#' @name cip1_raw
NULL

#' @rdname DecomposeR.Datasets
#' @name cip2
NULL

#' @rdname DecomposeR.Datasets
#' @name cip3
NULL
