/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.data.ColumnHeaderListener;
import org.rosuda.deducer.data.CopyPasteAdapter;
import org.rosuda.deducer.data.ExCellRenderer;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.ibase.Common;

public class ExTable
extends JTable {
    private CopyPasteAdapter excelCopyPaste;
    private ColumnHeaderListener columnListener;
    public JScrollPane parentPane = null;

    public ExTable() {
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setDefaultRenderer(Object.class, new ExCellRenderer());
        this.excelCopyPaste = new CopyPasteAdapter(this);
        this.columnListener = new ColumnHeaderListener(this);
        this.setAutoResizeMode(0);
        this.getTableHeader().setResizingAllowed(true);
    }

    public ExTable(ExDefaultTableModel exDefaultTableModel) {
        super(exDefaultTableModel);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setDefaultRenderer(Object.class, new ExCellRenderer());
        this.excelCopyPaste = new CopyPasteAdapter(this);
        this.columnListener = new ColumnHeaderListener(this);
        this.setAutoResizeMode(0);
        this.getTableHeader().setResizingAllowed(true);
    }

    public ColumnHeaderListener getColumnListener() {
        return this.columnListener;
    }

    public void setColumnListener(ColumnHeaderListener columnHeaderListener) {
        this.columnListener = columnHeaderListener;
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        final Component component = this.getEditorComponent();
        if (component != null && component instanceof JTextComponent) {
            if (eventObject == null || eventObject.getClass().toString().endsWith("KeyEvent")) {
                ((JTextComponent)component).selectAll();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((JTextComponent)component).selectAll();
                    }
                });
            }
        }
        return bl;
    }

    public void selectColumn(int n) {
        this.selectionModel.setValueIsAdjusting(true);
        this.changeSelection(this.getRowCount() - 1, n, false, false);
        if (Common.isMac()) {
            this.changeSelection(0, n, false, true);
        } else {
            this.changeSelection(0, n, true, true);
        }
        this.selectionModel.setValueIsAdjusting(false);
        this.requestFocus();
    }

    public void selectRow(int n) {
        this.selectionModel.setValueIsAdjusting(true);
        this.changeSelection(n, this.getColumnCount() - 1, false, false);
        if (Common.isMac()) {
            this.changeSelection(n, 0, false, true);
        } else {
            this.changeSelection(n, 0, true, true);
        }
        this.selectionModel.setValueIsAdjusting(false);
    }

    public CopyPasteAdapter getCopyPasteAdapter() {
        return this.excelCopyPaste;
    }

    public void copySelection() {
        this.excelCopyPaste.copy();
    }

    public void cutSelection() {
        this.excelCopyPaste.cut();
    }

    public void cutColumn(int n) {
        this.getCopyPasteAdapter().cut();
        this.removeColumn(n);
    }

    public void removeColumn(int n) {
        try {
            ((ExDefaultTableModel)this.getModel()).removeColumn(n);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void insertNewColumn(int n) {
        try {
            ((ExDefaultTableModel)this.getModel()).insertNewColumn(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertColumn(int n) {
        if (this.getCopyPasteAdapter().getClipBoard().indexOf("\t") != -1) {
            JOptionPane.showMessageDialog(null, "Invalid Insertion", "Invalid Insertion Selection", 0);
            return;
        }
        this.insertNewColumn(n);
        this.selectColumn(n);
        this.getCopyPasteAdapter().paste();
    }

    public void pasteSelection() {
        this.excelCopyPaste.paste();
    }

    public void cutRow(int n) {
        this.getCopyPasteAdapter().cut();
        this.removeRow(n);
    }

    public void removeRow(int n) {
        try {
            ((ExDefaultTableModel)this.getModel()).removeRow(n);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void insertNewRow(int n) {
        try {
            ((ExDefaultTableModel)this.getModel()).insertNewRow(n);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public Object getActualValueAt(int n, int n2) {
        return ((ExDefaultTableModel)this.getModel()).getActualValueAt(n, n2);
    }
}

