/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.osx.OSXApplication;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.security.AccessControlException;

public class OSXAquaPainter {
    private static volatile Boolean isNativeCodeAvailable;
    private long handle;
    private Widget widget;
    private static final int EXPECTED_NATIVE_CODE_VERSION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isNativeCodeAvailable() {
        if (isNativeCodeAvailable == null) {
            Class<OSXApplication> clazz = OSXApplication.class;
            // MONITORENTER : ch.randelshofer.quaqua.osx.OSXApplication.class
            if (isNativeCodeAvailable == null) {
                boolean success = false;
                try {
                    int nativeCodeVersion;
                    Toolkit.getDefaultToolkit().getSystemEventQueue();
                    String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
                    if (value == null) {
                        value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
                    }
                    if (value != null && value.equals("true")) {
                        success = true;
                    } else {
                        String osArch = System.getProperty("os.arch");
                        String[] libraryNames = osArch.equals("x86_64") ? new String[]{"quaqua64"} : new String[]{"quaqua64", "quaqua"};
                        for (String libraryName : libraryNames) {
                            try {
                                System.loadLibrary(libraryName);
                                success = true;
                                break;
                            }
                            catch (UnsatisfiedLinkError e) {
                                System.err.println("Warning: " + OSXApplication.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                success = false;
                            }
                            catch (AccessControlException e) {
                                System.err.println("Warning: " + OSXApplication.class + " access controller denied loading library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                success = false;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                System.err.println("Warning: " + OSXApplication.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                success = false;
                            }
                        }
                    }
                    if (success && (nativeCodeVersion = OSXAquaPainter.nativeGetNativeCodeVersion()) != 1) {
                        System.err.println("Warning: " + OSXApplication.class + " can't use library libquaqua.jnilib. It has version " + nativeCodeVersion + " instead of " + 1);
                        success = false;
                    }
                }
                finally {
                    isNativeCodeAvailable = success;
                }
            }
            // MONITOREXIT : clazz
        }
        if (isNativeCodeAvailable != Boolean.TRUE) return false;
        return true;
    }

    public void dispose() {
        this.releaseControl();
    }

    public Widget getWidget() {
        return this.widget;
    }

    private boolean createControl() {
        if (this.handle == 0L && OSXAquaPainter.isNativeCodeAvailable()) {
            this.handle = OSXAquaPainter.nativeCreateControl(false);
        }
        return this.handle != 0L;
    }

    private void releaseControl() {
        if (this.handle != 0L && OSXAquaPainter.isNativeCodeAvailable()) {
            OSXAquaPainter.nativeReleaseControl(this.handle);
            this.handle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.releaseControl();
    }

    public void setWidget(Widget widget) {
        this.widget = widget;
        if (this.createControl()) {
            OSXAquaPainter.nativeSetWidget(this.handle, widget.getId());
        }
    }

    public void setState(State state) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetState(this.handle, state.getId());
        }
    }

    public void setValueByKey(Key key, double value) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetValueByKey(this.handle, key.getId(), value);
        }
    }

    public void setSize(Size size) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetSize(this.handle, size.getId());
        }
    }

    public void setDirection(Direction direction) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetDirection(this.handle, direction.getId());
        }
    }

    public void setOrientation(Orientation orientation) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetOrientation(this.handle, orientation.getId());
        }
    }

    public void setHorizontalAlignment(HorizontalAlignment halignment) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetHorizontalAlignment(this.handle, halignment.getId());
        }
    }

    public void setVerticalAlignment(VerticalAlignment valignment) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetVerticalAlignment(this.handle, valignment.getId());
        }
    }

    public void setSegmentPosition(SegmentPosition segpos) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetSegmentPosition(this.handle, segpos.getId());
        }
    }

    public void setScrollBarPart(ScrollBarPart sbpart) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetScrollBarPart(this.handle, sbpart.getId());
        }
    }

    public void setVariant(Variant variant) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetVariant(this.handle, variant.getId());
        }
    }

    public void setWindowType(WindowType wtype) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetWindowType(this.handle, wtype.getId());
        }
    }

    public void setShowArrows(boolean b) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetShowArrows(this.handle, b);
        }
    }

    public void setAnimating(boolean b) {
        if (this.createControl()) {
            OSXAquaPainter.nativeSetAnimating(this.handle, b);
        }
    }

    public void paint(int[] imageData, int imgWidth, int imgHeight, double x, double y, double width, double height) {
        if (this.createControl()) {
            OSXAquaPainter.nativePaint(imageData, imgWidth, imgHeight, this.handle, x, (double)imgHeight - y - height, width, height);
        }
    }

    public void paint(BufferedImage image, double x, double y, double width, double height) {
        if (image.getType() != 3) {
            throw new IllegalArgumentException("Unsupported image type=" + image.getType());
        }
        if (this.createControl()) {
            int[] imgData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            int imgWidth = image.getWidth();
            int imgHeight = image.getHeight();
            int imgX = 0;
            int imgY = 0;
            WritableRaster raster = image.getRaster();
            while (raster.getParent() != null) {
                imgX -= raster.getMinX();
                imgY -= raster.getMinY();
                imgWidth = raster.getWidth();
                imgHeight = raster.getHeight();
            }
            OSXAquaPainter.nativePaint(imgData, imgWidth, imgHeight, this.handle, x, (double)imgHeight - y - height, width, height);
        }
    }

    private static native int nativeGetNativeCodeVersion();

    private static native long nativeCreateControl(boolean var0);

    private static native void nativeReleaseControl(long var0);

    private static native void nativeSetValueByKey(long var0, int var2, double var3);

    private static native void nativeSetWidget(long var0, int var2);

    private static native void nativeSetState(long var0, int var2);

    private static native void nativeSetSize(long var0, int var2);

    private static native void nativeSetDirection(long var0, int var2);

    private static native void nativeSetOrientation(long var0, int var2);

    private static native void nativeSetHorizontalAlignment(long var0, int var2);

    private static native void nativeSetVerticalAlignment(long var0, int var2);

    private static native void nativeSetSegmentPosition(long var0, int var2);

    private static native void nativeSetScrollBarPart(long var0, int var2);

    private static native void nativeSetVariant(long var0, int var2);

    private static native void nativeSetWindowType(long var0, int var2);

    private static native void nativeSetShowArrows(long var0, boolean var2);

    private static native void nativeSetAnimating(long var0, boolean var2);

    private static native void nativePaint(int[] var0, int var1, int var2, long var3, double var5, double var7, double var9, double var11);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindowType {
        document(1),
        utility(2),
        titlelessUtility(3);

        private int id;

        private WindowType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variant {
        menuGlyph(1),
        menuPopup(2),
        menuPulldown(3),
        menuHierarchical(4),
        gradientListBackgroundEven(5),
        gradientListBackgroundOdd(6),
        gradientSideBar(7),
        gradientSideBarSelection(8),
        gradientSideBarFocusedSelection(9);

        private int id;

        private Variant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScrollBarPart {
        none(1),
        thumb(2),
        arrowMin(3),
        arrowMax(4),
        arrowMaxInside(5),
        arrowMinInside(6),
        trackMin(7),
        trackMax(8);

        private int id;

        private ScrollBarPart(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SegmentPosition {
        first(1),
        middle(2),
        last(3),
        only(4);

        private int id;

        private SegmentPosition(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalAlignment {
        top(1),
        center(2),
        bottom(3);

        private int id;

        private VerticalAlignment(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalAlignment {
        left(1),
        center(2),
        right(3);

        private int id;

        private HorizontalAlignment(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        horizontal(1),
        vertical(2);

        private int id;

        private Orientation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        none(1),
        up(2),
        down(3),
        left(4),
        right(5),
        north(6),
        south(7),
        east(8),
        west(9);

        private int id;

        private Direction(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Size {
        mini(1),
        small(2),
        regular(3),
        large(4);

        private int id;

        private Size(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        active(1),
        inactive(2),
        disabled(3),
        pressed(4),
        pulsed(5),
        rollover(6),
        drag(7);

        private int id;

        private State(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Widget {
        background(1),
        buttonBevel(2),
        buttonBevelInset(3),
        buttonBevelRound(4),
        buttonCheckBox(5),
        buttonComboBox(6),
        buttonComboBoxInset(7),
        buttonDisclosure(8),
        buttonListHeader(9),
        buttonLittleArrows(10),
        buttonPopDown(11),
        buttonPopDownInset(12),
        buttonPopDownSquare(13),
        buttonPopUp(14),
        buttonPopUpInset(15),
        buttonPopUpSquare(16),
        buttonPush(17),
        buttonPushScope(18),
        buttonPushScope2(19),
        buttonPushTextured(20),
        buttonPushInset(21),
        buttonPushInset2(22),
        buttonRadio(23),
        buttonRound(24),
        buttonRoundHelp(25),
        buttonRoundInset(26),
        buttonRoundInset2(27),
        buttonSearchFieldCancel(28),
        buttonSearchFieldFind(29),
        buttonSegmented(30),
        buttonSegmentedInset(31),
        buttonSegmentedInset2(32),
        buttonSegmentedSCurve(33),
        buttonSegmentedTextured(34),
        buttonSegmentedToolbar(35),
        dial(36),
        disclosureTriangle(37),
        dividerGrabber(38),
        dividerSeparatorBar(39),
        dividerSplitter(40),
        focus(41),
        frameGroupBox(42),
        frameGroupBoxSecondary(43),
        frameListBox(44),
        framePlacard(45),
        frameTextField(46),
        frameTextFieldRound(47),
        frameWell(48),
        growBox(49),
        growBoxTextured(50),
        gradient(51),
        menu(52),
        menuItem(53),
        menuBar(54),
        menuTitle(55),
        progressBar(56),
        progressIndeterminateBar(57),
        progressRelevance(58),
        progressSpinner(59),
        scrollBar(60),
        scrollColumnSizer(61),
        slider(62),
        sliderThumb(63),
        synchronization(64),
        tab(65),
        titleBarCloseBox(66),
        titleBarCollapseBox(67),
        titleBarZoomBox(68),
        titleBarToolbarButton(69),
        toolbarItemWell(70),
        windowFrame(71);

        private int id;

        private Widget(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        widget(1),
        state(2),
        size(3),
        direction(4),
        orientation(5),
        verticalAlignment(6),
        horizontalAlignment(7),
        position(8),
        pressedPart(9),
        variant(10),
        windowType(11),
        focused(12),
        indicatorOnly(13),
        noIndicator(14),
        nothingToScroll(15),
        arrowsOnly(16),
        frameOnly(17),
        segmentTrailingSeparator(18),
        maximumValue(19),
        value(20),
        animationStartTime(21),
        animationTime(22),
        animationFrame(23),
        thumbProportion(24),
        thumbStart(25),
        windowFrameDrawClipped(26),
        windowFrameDrawTitleSeparator(27),
        windowTitleBarHeight(28);

        private int id;

        private Key(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

