/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.OneSamplePlots;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.SubsetPanel;
import org.rosuda.deducer.toolkit.AssumptionIcon;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.VariableSelector;

public class OneSampleDialog
extends JDialog
implements ActionListener {
    private VariableSelector variableSelector;
    private IconButton remove;
    private JButton plots;
    private JPanel testPanel;
    private IconButton ttestOptions;
    private JSeparator sep;
    private JCheckBox swTest;
    private JLabel swLabel;
    private JButton help;
    private JPanel navPanel;
    private JCheckBox ttest;
    private JPanel subsetWrapper;
    private IconButton add;
    private JPanel variables;
    private IconButton assumpNOrNorm;
    private IconButton assumpOutlier;
    private IconButton assumpN;
    private DJList vars = new DJList();
    private SubsetPanel subsetPanel;
    private OneSampleModel model = new OneSampleModel();
    private static OneSampleModel lastModel;

    public OneSampleDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
        if (lastModel != null) {
            this.setModel(lastModel);
        }
        this.variableSelector.getJComboBox().addActionListener(this);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("pmwiki.php?n=Main.OneSampleTest");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(915, 86, 990, 23, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(26, 406, 630, 12, 1, 1, 1, 2));
            this.variableSelector.setBorder(BorderFactory.createTitledBorder("variables"));
            this.variableSelector.setPreferredSize(new Dimension(206, 303));
            this.variables = new JPanel();
            this.getContentPane().add((Component)this.variables, new AnchorConstraint(27, 20, 630, 567, 1, 2, 1, 1));
            this.variables.setBorder(BorderFactory.createTitledBorder("Variables"));
            this.variables.setLayout(new BorderLayout());
            this.vars = new DJList();
            this.vars.setModel(new DefaultListModel());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.vars);
            this.variables.add((Component)jScrollPane, "Center");
            this.variables.setPreferredSize(new Dimension(213, 275));
            this.add = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add((Component)this.add, new AnchorConstraint(101, 521, 297, 458, 2, 0, 0, 1));
            this.add.setPreferredSize(new Dimension(36, 36));
            this.add.setContentAreaFilled(false);
            this.remove = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add((Component)this.remove, new AnchorConstraint(138, 521, 371, 458, 2, 0, 0, 1));
            this.remove.setPreferredSize(new Dimension(36, 36));
            this.remove.setContentAreaFilled(false);
            this.subsetWrapper = new JPanel();
            this.subsetWrapper.setLayout(new BorderLayout());
            this.subsetPanel = new SubsetPanel(this.variableSelector.getJComboBox());
            this.subsetWrapper.add(this.subsetPanel);
            this.getContentPane().add((Component)this.subsetWrapper, new AnchorConstraint(702, 20, 876, 567, 1, 2, 1, 1));
            this.subsetWrapper.setBorder(BorderFactory.createTitledBorder("Subset"));
            this.subsetWrapper.setPreferredSize(new Dimension(213, 79));
            this.plots = new JButton();
            this.getContentPane().add((Component)this.plots, new AnchorConstraint(645, 842, 691, 696, 1, 1, 0, 0));
            this.plots.setText("Plots");
            this.plots.setPreferredSize(new Dimension(79, 21));
            this.plots.addActionListener(this);
            this.testPanel = new JPanel();
            this.getContentPane().add((Component)this.testPanel, new AnchorConstraint(642, 406, 63, 12, 1, 1, 0, 2));
            this.testPanel.setBorder(BorderFactory.createTitledBorder(null, "Tests", 4, 0));
            this.testPanel.setLayout(null);
            this.testPanel.setPreferredSize(new Dimension(206, 140));
            this.ttest = new JCheckBox();
            this.testPanel.add(this.ttest);
            this.ttest.setText("One-sample t-test");
            this.ttest.setBounds(17, 19, 155, 18);
            this.ttestOptions = new IconButton("/icons/advanced_21.png", "t-test Options", this, "t-test Options");
            this.testPanel.add(this.ttestOptions);
            this.ttestOptions.setBounds(171, 17, 27, 27);
            this.ttestOptions.setContentAreaFilled(false);
            this.assumpNOrNorm = new AssumptionIcon("/icons/N_or_norm_assump.png", "Large Sample or Normality", this, "Large Sample or Normality");
            this.testPanel.add(this.assumpNOrNorm);
            this.assumpNOrNorm.setBounds(40, 40, 47, 27);
            this.assumpOutlier = new AssumptionIcon("/icons/outlier_assump.png", "No Outliers", this, "No Outliers");
            this.testPanel.add(this.assumpOutlier);
            this.assumpOutlier.setBounds(90, 40, 27, 27);
            this.swTest = new JCheckBox();
            this.testPanel.add(this.swTest);
            this.swTest.setText("Shapiro-Wilk test");
            this.swTest.setBounds(17, 77, 170, 18);
            this.swLabel = new JLabel();
            this.testPanel.add(this.swLabel);
            this.swLabel.setText("against normality");
            this.swLabel.setBounds(40, 93, 116, 18);
            this.assumpN = new AssumptionIcon("/icons/N_assump.png", "Large Sample", this, "Large Sample");
            this.testPanel.add(this.assumpN);
            this.assumpN.setBounds(40, 107, 27, 27);
            this.sep = new JSeparator();
            this.testPanel.add(this.sep);
            this.sep.setBounds(40, 71, 105, 6);
            this.navPanel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.navPanel, new AnchorConstraint(889, 963, 976, 480, 0, 1, 1, 0));
            this.navPanel.setPreferredSize(new Dimension(280, 46));
            this.setMinimumSize(new Dimension(546, 331));
            this.setSize(546, 536);
            this.setTitle("One Sample Test");
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(OneSampleModel oneSampleModel) {
        this.model = new OneSampleModel();
        this.variableSelector.reset();
        if (oneSampleModel.data != null) {
            this.variableSelector.setSelectedData(oneSampleModel.data);
        }
        this.model = oneSampleModel;
        this.ttest.setSelected(oneSampleModel.doT);
        this.swTest.setSelected(oneSampleModel.doSW);
        boolean bl = this.variableSelector.removeAll(oneSampleModel.vars);
        if (bl) {
            this.vars.setModel(oneSampleModel.vars);
            this.model.subset = oneSampleModel.subset;
            this.subsetPanel.setText(oneSampleModel.subset);
            this.model.vars = oneSampleModel.vars;
        } else {
            this.variableSelector.reset();
            this.vars.setModel(new DefaultListModel());
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "t-test Options") {
            OneSampleTOptions oneSampleTOptions = new OneSampleTOptions(this, this.model.alternative, this.model.mu);
            oneSampleTOptions.setLocationRelativeTo(this);
            oneSampleTOptions.setVisible(true);
        } else if (string == "Run") {
            this.model.data = this.variableSelector.getSelectedData();
            this.model.vars = (DefaultListModel)this.vars.getModel();
            this.model.doT = this.ttest.isSelected();
            this.model.doSW = this.swTest.isSelected();
            this.model.subset = this.subsetPanel.getText();
            boolean bl = this.model.run();
            if (bl) {
                lastModel = this.model;
                Deducer.setRecentData(this.model.data);
                SubsetDialog.addToHistory(this.model.data, this.model.subset);
                this.dispose();
            }
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Reset") {
            this.setModel(new OneSampleModel());
        } else if (string == "Add") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.vars.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove") {
            Object[] objectArray = this.vars.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.vars.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "comboBoxChanged") {
            this.setModel(new OneSampleModel());
        } else if (string == "Plots") {
            OneSamplePlots oneSamplePlots = new OneSamplePlots(this, this.model.plots);
            oneSamplePlots.setLocationRelativeTo(this);
            oneSamplePlots.setVisible(true);
        }
    }

    class OneSampleTOptions
    extends JDialog
    implements ActionListener {
        private JPanel alternativePanel;
        private ButtonGroup alternativeGroup;
        private JRadioButton twosided;
        private JPanel okayCancelPanel;
        private JLabel muLabel;
        private JTextField mu;
        private JRadioButton greater;
        private JRadioButton less;

        public OneSampleTOptions(JDialog jDialog, String string, double d) {
            super(jDialog);
            this.initGUI();
            if (string == "two.sided") {
                this.twosided.setSelected(true);
            } else if (string == "less") {
                this.less.setSelected(true);
            } else {
                this.greater.setSelected(true);
            }
            this.mu.setText(Double.toString(d));
        }

        private void initGUI() {
            try {
                this.getContentPane().setLayout(null);
                this.alternativePanel = new JPanel();
                this.getContentPane().add(this.alternativePanel);
                this.alternativePanel.setBounds(42, 12, 145, 115);
                this.alternativePanel.setBorder(BorderFactory.createTitledBorder("Alternative"));
                this.alternativePanel.setLayout(null);
                this.twosided = new JRadioButton();
                this.alternativePanel.add(this.twosided);
                this.twosided.setText("Two-sided");
                this.twosided.setBounds(17, 24, 115, 18);
                this.less = new JRadioButton();
                this.alternativePanel.add(this.less);
                this.less.setText("Less");
                this.less.setBounds(17, 49, 115, 18);
                this.greater = new JRadioButton();
                this.alternativePanel.add(this.greater);
                this.greater.setText("Greater");
                this.greater.setBounds(17, 79, 115, 18);
                this.mu = new JTextField("0");
                this.getContentPane().add(this.mu);
                this.mu.setBounds(115, 136, 48, 21);
                this.muLabel = new JLabel();
                this.muLabel.setText("Test mean:");
                this.getContentPane().add(this.muLabel);
                this.muLabel.setBounds(24, 139, 88, 14);
                this.okayCancelPanel = new OkayCancelPanel(false, false, this);
                this.getContentPane().add(this.okayCancelPanel);
                this.okayCancelPanel.setBounds(10, 165, 200, 38);
                this.getAlternativeGroup();
                this.setTitle("One-sample t-test options");
                this.setResizable(false);
                this.setSize(246, 249);
                this.setModal(true);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }

        private ButtonGroup getAlternativeGroup() {
            if (this.alternativeGroup == null) {
                this.alternativeGroup = new ButtonGroup();
                this.alternativeGroup.add(this.twosided);
                this.alternativeGroup.add(this.less);
                this.alternativeGroup.add(this.greater);
            }
            return this.alternativeGroup;
        }

        public String getAlternative() {
            if (this.twosided.isSelected()) {
                return "two.sided";
            }
            if (this.less.isSelected()) {
                return "less";
            }
            return "greater";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "OK") {
                try {
                    ((OneSampleDialog)OneSampleDialog.this).model.mu = Double.parseDouble(this.mu.getText());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Sorry, the entered mean doesn't seem to be valid.\n please enter a number.");
                    return;
                }
                ((OneSampleDialog)OneSampleDialog.this).model.alternative = this.getAlternative();
                this.dispose();
            } else if (string == "Cancel") {
                this.dispose();
            }
        }
    }

    class OneSampleModel {
        double mu = 0.0;
        String alternative = "two.sided";
        boolean doT = true;
        boolean doSW = false;
        String data = null;
        DefaultListModel vars = new DefaultListModel();
        String subset = "";
        PlotModel plots = new PlotModel();

        OneSampleModel() {
        }

        public boolean run() {
            if (this.vars.getSize() == 0) {
                JOptionPane.showMessageDialog(null, "Please select one or more variables.");
                return false;
            }
            String string = Deducer.makeRCollection(this.vars, "d", false);
            String string2 = "";
            String string3 = "";
            boolean bl = false;
            if (!this.subset.equals("")) {
                if (!SubsetDialog.isValidSubsetExp(this.subset, this.data)) {
                    JOptionPane.showMessageDialog(null, "Sorry, the subset expression seems to be invalid.");
                    return false;
                }
                string3 = Deducer.getUniqueName(this.data + ".sub");
                string2 = string3 + "<-subset(" + this.data + "," + this.subset + ")" + "\n";
                bl = true;
            } else {
                string3 = this.data;
            }
            string2 = string2 + "descriptive.table(vars=" + string + ",data=" + string3 + ",func.names =c(\"Mean\",\"St. Deviation\",\"Valid N\"))\n";
            if (this.doT) {
                string2 = string2 + "one.sample.test(variables=" + string + ",\n\tdata=" + string3 + ",\n\ttest=t.test" + ",\n\talternative=\"" + this.alternative + "\"" + (this.mu != 0.0 ? ",\n\tmu=" + Double.toString(this.mu) : "") + ")\n";
            }
            if (this.doSW) {
                string2 = string2 + "one.sample.test(variables=" + string + ",\n\tdata=" + string3 + ",\n\ttest=shapiro.test" + ")\n";
            }
            if (this.plots.plot) {
                string2 = string2 + "onesample.plot(variables=" + string + ",data=" + string3 + (this.doT ? ",test.value=" + Double.toString(this.mu) : "") + (!this.plots.scale ? "" : ",scale=TRUE") + (this.plots.box ? ",type='box'" : ",type='hist'") + ",alpha=" + this.plots.alpha + ")\n";
            }
            if (bl) {
                string2 = string2 + "rm(" + string3 + ")\n";
            }
            Deducer.execute(string2);
            return true;
        }

        public class PlotModel {
            public boolean plot = false;
            public boolean box = false;
            public boolean scale = false;
            public double alpha = 0.2;
        }
    }
}

