/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu.twosample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.KSamplePlots;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.SubsetPanel;
import org.rosuda.deducer.menu.twosample.SplitDialog;
import org.rosuda.deducer.menu.twosample.TestOptions;
import org.rosuda.deducer.menu.twosample.TwoSampleModel;
import org.rosuda.deducer.toolkit.AssumptionIcon;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.SingletonAddRemoveButton;
import org.rosuda.deducer.toolkit.SingletonDJList;
import org.rosuda.deducer.toolkit.VariableSelector;

public class TwoSampleDialog
extends JDialog
implements ActionListener {
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JPanel outcomePanel;
    private IconButton lrgAssump;
    private IconButton lrgAssump2;
    private JCheckBox boot;
    private JSeparator sep1;
    private IconButton ttestOptions;
    private IconButton lrgAssump3;
    private JCheckBox bmTest;
    private JSeparator sep2;
    private IconButton exchAssump;
    private IconButton jButton1;
    private IconButton mwOptions;
    private SingletonAddRemoveButton addFactor;
    private IconButton removeOutcome;
    private IconButton addOutcome;
    private JButton help;
    private JPanel buttonPanel;
    private JButton plots;
    private JLabel kmLabel;
    private JButton kmOptions;
    private IconButton lrgSample4;
    private JCheckBox kmTest;
    private JPanel distributionPanel;
    private JButton bmOptions;
    private JCheckBox mannWhitney;
    private JPanel aucPanel;
    private JPanel subset;
    private SubsetPanel subsetPanel;
    private IconButton bootOptions;
    private JCheckBox ttest;
    private SingletonDJList factor;
    private JList outcomes;
    private JScrollPane varScroller;
    private JButton Options;
    private JButton other;
    private IconButton outlierAssump1;
    private IconButton outlierAssum;
    private JPanel meanPanel;
    private JButton split;
    private JPanel factorPanel;
    private VariableSelector variableSelector;
    private TwoSampleModel testModel = new TwoSampleModel();
    private IconButton exchAssump2;
    private IconButton approxAssump;
    private static TwoSampleModel lastModel;

    public TwoSampleDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
        if (lastModel != null) {
            this.setModel(lastModel);
        } else {
            this.setModel(new TwoSampleModel());
        }
        this.bmOptions.setVisible(false);
        this.mwOptions.setVisible(false);
        this.kmOptions.setVisible(false);
        this.other.setVisible(false);
    }

    private void initGUI() {
        try {
            BorderLayout borderLayout = new BorderLayout();
            this.getContentPane().setLayout(borderLayout);
            this.bottomPanel = new JPanel();
            this.getContentPane().add((Component)this.bottomPanel, "South");
            AnchorLayout anchorLayout = new AnchorLayout();
            this.bottomPanel.setLayout((LayoutManager)anchorLayout);
            this.bottomPanel.setPreferredSize(new Dimension(547, 231));
            this.Options = new JButton();
            this.bottomPanel.add((Component)this.Options, new AnchorConstraint(117, 910, 603, 756, 2, 0, 0, 1));
            this.Options.setText("Options");
            this.Options.setPreferredSize(new Dimension(94, 22));
            this.Options.addActionListener(this);
            this.other = new JButton();
            this.bottomPanel.add((Component)this.other, new AnchorConstraint(145, 794, 651, 756, 2, 0, 0, 1));
            this.other.setText("Other Tests");
            this.other.setPreferredSize(new Dimension(94, 22));
            this.help = new HelpButton("pmwiki.php?n=Main.TwoSampleTest");
            this.bottomPanel.add((Component)this.help, new AnchorConstraint(820, 83, 900, 14, 0, 0, 1, 2));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.buttonPanel = new OkayCancelPanel(true, true, this);
            this.bottomPanel.add((Component)this.buttonPanel, new AnchorConstraint(172, 12, 950, 578, 2, 2, 0, 0));
            this.buttonPanel.setPreferredSize(new Dimension(300, 59));
            this.distributionPanel = new JPanel();
            this.bottomPanel.add((Component)this.distributionPanel, new AnchorConstraint(12, 981, 482, 666, 2, 1, 0, 1));
            this.distributionPanel.setPreferredSize(new Dimension(192, 99));
            this.distributionPanel.setBorder(BorderFactory.createTitledBorder("Distribution"));
            this.distributionPanel.setLayout(null);
            this.kmTest = new JCheckBox();
            this.distributionPanel.add(this.kmTest);
            this.kmTest.setText("Kolmogorov-");
            this.kmTest.setBounds(17, 19, 132, 18);
            this.lrgSample4 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.distributionPanel.add(this.lrgSample4);
            this.lrgSample4.setBounds(38, 60, 27, 27);
            this.kmOptions = new JButton();
            this.distributionPanel.add(this.kmOptions);
            this.kmOptions.setText("Kolmogorov-Smirnov Options");
            this.kmOptions.setBounds(149, 27, 27, 27);
            this.kmOptions.addActionListener(this);
            this.kmLabel = new JLabel();
            this.distributionPanel.add(this.kmLabel);
            this.kmLabel.setText("Smirnov");
            this.kmLabel.setBounds(50, 40, 58, 14);
            this.aucPanel = new JPanel();
            this.bottomPanel.add((Component)this.aucPanel, new AnchorConstraint(12, 666, 751, 318, 2, 1, 0, 1));
            this.aucPanel.setPreferredSize(new Dimension(212, 160));
            this.aucPanel.setBorder(BorderFactory.createTitledBorder("Central Tendency (AUC)"));
            this.aucPanel.setLayout(null);
            this.mannWhitney = new JCheckBox();
            this.aucPanel.add(this.mannWhitney);
            this.mannWhitney.setText("Wilcoxon");
            this.mannWhitney.setBounds(17, 19, 151, 18);
            this.mwOptions = new IconButton("/icons/advanced_21.png", "Wilcoxon Options", this, "Wilcoxon Options");
            this.aucPanel.add(this.mwOptions);
            this.mwOptions.setText("Mann-Whitney Options");
            this.mwOptions.setBounds(168, 15, 27, 27);
            this.jButton1 = new IconButton("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.aucPanel.add(this.jButton1);
            this.jButton1.setBounds(35, 40, 27, 27);
            this.exchAssump = new AssumptionIcon("/icons/eqvar_assump.png", "Exchangablility", null, "Exchangablility");
            this.aucPanel.add(this.exchAssump);
            this.exchAssump.setBounds(62, 40, 27, 27);
            this.sep2 = new JSeparator();
            this.aucPanel.add(this.sep2);
            this.sep2.setBounds(35, 78, 128, 10);
            this.bmTest = new JCheckBox();
            this.aucPanel.add(this.bmTest);
            this.bmTest.setText("Brunner-Munzel");
            this.bmTest.setBounds(17, 88, 151, 18);
            this.lrgAssump3 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.aucPanel.add(this.lrgAssump3);
            this.lrgAssump3.setBounds(35, 109, 27, 27);
            this.bmOptions = new JButton();
            this.aucPanel.add(this.bmOptions);
            this.bmOptions.setText("Brunner-Munzel Options");
            this.bmOptions.setBounds(168, 84, 27, 27);
            this.bmOptions.addActionListener(this);
            this.meanPanel = new JPanel();
            this.bottomPanel.add((Component)this.meanPanel, new AnchorConstraint(12, 318, 569, 23, 2, 1, 0, 1));
            this.meanPanel.setPreferredSize(new Dimension(180, 160));
            this.meanPanel.setLayout(null);
            this.meanPanel.setBorder(BorderFactory.createTitledBorder(null, "Mean", 4, 2));
            this.ttest = new JCheckBox();
            this.meanPanel.add(this.ttest);
            this.ttest.setText("T-Test");
            this.ttest.setBounds(17, 19, 85, 18);
            this.lrgAssump = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.meanPanel.add(this.lrgAssump);
            this.lrgAssump.setBounds(34, 40, 27, 27);
            this.ttestOptions = new IconButton("/icons/advanced_21.png", "t-test options", this, "t-test options");
            this.meanPanel.add(this.ttestOptions);
            this.ttestOptions.setBounds(140, 15, 27, 27);
            this.exchAssump2 = new AssumptionIcon("/icons/eqvar_assump.png", "Equal Variance", null, "Equal Variance");
            this.meanPanel.add(this.exchAssump2);
            this.exchAssump2.setBounds(108, 40, 27, 27);
            this.sep1 = new JSeparator();
            this.meanPanel.add(this.sep1);
            this.sep1.setBounds(34, 83, 129, 10);
            this.boot = new JCheckBox();
            this.meanPanel.add(this.boot);
            this.boot.setText("Permutation");
            this.boot.setBounds(17, 91, 111, 18);
            this.lrgAssump2 = new AssumptionIcon("/icons/N_or_exch_assump.png", "Large Sample or exchangable", null, "Large Sample or exchangable");
            this.meanPanel.add(this.lrgAssump2);
            this.lrgAssump2.setBounds(34, 112, 47, 27);
            this.bootOptions = new IconButton("/icons/advanced_21.png", "Permutation Options", this, "Permutation Options");
            this.meanPanel.add(this.bootOptions);
            this.bootOptions.setBounds(140, 89, 27, 27);
            this.outlierAssum = new AssumptionIcon("/icons/outlier_assump.png", "No Outliers", this, "No Outliers");
            this.meanPanel.add(this.outlierAssum);
            this.outlierAssum.setBounds(81, 40, 27, 27);
            this.outlierAssump1 = new AssumptionIcon("/icons/outlier_assump.png", "No Outliers", this, "No Outliers");
            this.meanPanel.add(this.outlierAssump1);
            this.outlierAssump1.setBounds(81, 112, 27, 27);
            this.approxAssump = new AssumptionIcon("/icons/mcapprox_assump.png", "Monte Carlo Approximation", this, "Monte Carlo Approximation");
            this.meanPanel.add(this.approxAssump);
            this.approxAssump.setBounds(108, 112, 27, 27);
            this.topPanel = new JPanel();
            this.getContentPane().add((Component)this.topPanel, "Center");
            anchorLayout = new AnchorLayout();
            this.topPanel.setLayout((LayoutManager)anchorLayout);
            this.topPanel.setPreferredSize(new Dimension(547, 304));
            this.removeOutcome = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.topPanel.add((Component)this.removeOutcome, new AnchorConstraint(295, 535, 378, 484, 0, 1, 1, 0));
            this.removeOutcome.setPreferredSize(new Dimension(35, 35));
            this.addOutcome = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.topPanel.add((Component)this.addOutcome, new AnchorConstraint(161, 535, 264, 474, 0, 1, 1, 0));
            this.addOutcome.setPreferredSize(new Dimension(35, 35));
            this.split = new JButton();
            this.topPanel.add((Component)this.split, new AnchorConstraint(751, 861, 810, 709, 1, 0, 0, 1));
            this.split.setText("Split");
            this.split.setPreferredSize(new Dimension(83, 21));
            this.split.addActionListener(this);
            this.factorPanel = new JPanel();
            BorderLayout borderLayout2 = new BorderLayout();
            this.factorPanel.setLayout(borderLayout2);
            this.topPanel.add((Component)this.factorPanel, new AnchorConstraint(620, 979, 750, 582, 1, 1, 1, 1));
            this.factorPanel.setPreferredSize(new Dimension(242, 51));
            this.factorPanel.setBorder(BorderFactory.createTitledBorder("Factor"));
            DefaultListModel defaultListModel = new DefaultListModel();
            this.factor = new SingletonDJList();
            this.factorPanel.add((Component)this.factor, "Center");
            this.factor.setModel(defaultListModel);
            this.addFactor = new SingletonAddRemoveButton(new String[]{"Add Factor", "Remove Factor"}, this, new String[]{"Add Factor", "Remove Factor"}, this.factor);
            this.topPanel.add((Component)this.addFactor, new AnchorConstraint(628, 539, 750, 464, 0, 1, 1, 0));
            this.addFactor.setPreferredSize(new Dimension(37, 37));
            this.outcomePanel = new JPanel();
            borderLayout2 = new BorderLayout();
            this.topPanel.add((Component)this.outcomePanel, new AnchorConstraint(32, 980, 612, 584, 1, 1, 1, 1));
            this.outcomePanel.setPreferredSize(new Dimension(216, 203));
            this.outcomePanel.setLayout(borderLayout2);
            this.outcomePanel.setBorder(BorderFactory.createTitledBorder("Outcomes"));
            this.varScroller = new JScrollPane();
            this.outcomePanel.add((Component)this.varScroller, "Center");
            defaultListModel = new DefaultListModel();
            this.outcomes = new DJList();
            this.varScroller.setViewportView(this.outcomes);
            this.outcomes.setModel(defaultListModel);
            this.variableSelector = new VariableSelector();
            this.topPanel.add((Component)this.variableSelector, new AnchorConstraint(31, 430, 827, 23, 1, 1, 1, 1));
            this.variableSelector.setBorder(BorderFactory.createEtchedBorder(1));
            this.variableSelector.setPreferredSize(new Dimension(248, 288));
            this.subset = new JPanel();
            this.subset.setLayout(new BorderLayout());
            this.subsetPanel = new SubsetPanel(this.variableSelector.getJComboBox());
            this.subset.add(this.subsetPanel);
            this.topPanel.add((Component)this.subset, new AnchorConstraint(800, 979, 1003, 582, 1, 1, 1, 1));
            this.subset.setBorder(BorderFactory.createTitledBorder("Subset"));
            this.plots = new JButton();
            this.topPanel.add((Component)this.plots, new AnchorConstraint(893, 297, 968, 156, 1, 1, 1, 1));
            this.plots.setText("Plots");
            this.plots.addActionListener(this);
            this.plots.setPreferredSize(new Dimension(86, 27));
            this.variableSelector.getJComboBox().addActionListener(this);
            this.setTitle("Two Independent Sample Tests");
            this.setMinimumSize(new Dimension(600, 400));
            this.setSize(610, 630);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(TwoSampleModel twoSampleModel) {
        this.testModel = twoSampleModel;
        this.factor.setModel(new DefaultListModel());
        this.addFactor.refreshListListener();
        this.outcomes.setModel(new DefaultListModel());
        if (twoSampleModel.dataName != null) {
            this.variableSelector.setSelectedData(twoSampleModel.dataName);
            boolean bl = this.variableSelector.removeAll(twoSampleModel.variables);
            if (!bl) {
                this.reset();
                return;
            }
            this.outcomes.setModel(twoSampleModel.variables);
            bl = this.variableSelector.removeAll(twoSampleModel.factorName);
            if (!bl) {
                this.reset();
                this.addFactor.refreshListListener();
                return;
            }
            this.factor.setModel(twoSampleModel.factorName);
            this.addFactor.refreshListListener();
            if (twoSampleModel.subset == "" || RController.isValidSubsetExp((String)twoSampleModel.subset, (String)twoSampleModel.dataName)) {
                this.subsetPanel.setText(twoSampleModel.subset);
            }
        }
        if (twoSampleModel.subset == "") {
            this.subsetPanel.setText(twoSampleModel.subset);
        }
        this.ttest.setSelected(twoSampleModel.doT);
        this.boot.setSelected(twoSampleModel.doBoot);
        this.kmTest.setSelected(twoSampleModel.doKS);
        this.mannWhitney.setSelected(twoSampleModel.doMW);
        this.bmTest.setSelected(twoSampleModel.doBM);
        this.testModel = twoSampleModel;
        if (this.testModel.bootStat == "t") {
            this.lrgAssump2.setIcon("/icons/N_or_exch_assump.png");
            this.lrgAssump2.setToolTipText("Large sample or Exchangable");
            this.lrgAssump2.setSize(47, 27);
        } else {
            this.lrgAssump2.setIcon("/icons/eqvar_assump.png");
            this.lrgAssump2.setToolTipText("Exchangable");
            this.lrgAssump2.setSize(27, 27);
        }
        if (!this.testModel.tEqVar) {
            this.exchAssump2.setVisible(false);
            this.lrgAssump.setIcon("/icons/N_assump.png");
            this.lrgAssump.setToolTipText("Large Sample");
            this.lrgAssump.setSize(27, 27);
        } else {
            this.exchAssump2.setVisible(true);
            this.lrgAssump.setIcon("/icons/N_or_norm_assump.png");
            this.lrgAssump.setToolTipText("Large sample or Normal");
            this.lrgAssump.setSize(47, 27);
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    public void reset() {
        this.setModel(new TwoSampleModel());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Split") {
            SplitDialog splitDialog = new SplitDialog(this, this.testModel.splitMod, this.variableSelector.getSelectedData(), this.factor.getModel().getSize() == 0 ? null : this.factor.getModel().getElementAt(0));
            splitDialog.setLocationRelativeTo(this);
            splitDialog.setVisible(true);
        } else if (string == "Options") {
            TestOptions testOptions = new TestOptions(this, this.testModel.optMod);
            testOptions.setLocationRelativeTo(this);
            testOptions.setVisible(true);
        } else if (string == "Run") {
            this.testModel.doT = this.ttest.isSelected();
            this.testModel.doBoot = this.boot.isSelected();
            this.testModel.doKS = this.kmTest.isSelected();
            this.testModel.doMW = this.mannWhitney.isSelected();
            this.testModel.doBM = this.bmTest.isSelected();
            this.testModel.factorName = (DefaultListModel)this.factor.getModel();
            this.testModel.variables = (DefaultListModel)this.outcomes.getModel();
            this.testModel.subset = this.subsetPanel.getText();
            this.testModel.dataName = this.variableSelector.getSelectedData();
            boolean bl = this.testModel.run();
            if (bl) {
                lastModel = this.testModel;
                SubsetDialog.addToHistory(this.testModel.dataName, this.testModel.subset);
                Deducer.setRecentData(this.testModel.dataName);
                this.dispose();
            }
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Reset") {
            this.reset();
        } else if (string == "t-test options") {
            String string2 = (String)JOptionPane.showInputDialog(this, "t-test Variant", "t-test Options", 1, null, new String[]{"Unequal variance (Welch) (Recommended)", "Equal variance (Student)"}, this.testModel.tEqVar ? "Equal variance (Student)" : "Unequal variance (Welch) (Recommended)");
            if (string2 == null) {
                return;
            }
            if (string2.startsWith("Unequal")) {
                this.exchAssump2.setVisible(false);
                this.lrgAssump.setIcon("/icons/N_assump.png");
                this.lrgAssump.setToolTipText("Large Sample");
                this.lrgAssump.setSize(27, 27);
                this.testModel.tEqVar = false;
            } else {
                this.exchAssump2.setVisible(true);
                this.lrgAssump.setIcon("/icons/N_or_norm_assump.png");
                this.lrgAssump.setToolTipText("Large sample or Normal");
                this.lrgAssump.setSize(47, 27);
                this.testModel.tEqVar = true;
            }
        } else if (string == "Permutation Options") {
            String string3 = (String)JOptionPane.showInputDialog(this, "Permutation Statistic", "Permutation Options", 1, null, new String[]{"t (Recommended)", "mean"}, this.testModel.bootStat == "t" ? "t (Recommended)" : "mean");
            if (string3 == null) {
                return;
            }
            if (string3.startsWith("t")) {
                this.testModel.bootStat = "t";
                this.lrgAssump2.setIcon("/icons/N_or_exch_assump.png");
                this.lrgAssump2.setToolTipText("Large sample or Exchangable");
                this.lrgAssump2.setSize(47, 27);
            } else {
                this.testModel.bootStat = "mean";
                this.lrgAssump2.setIcon("/icons/eqvar_assump.png");
                this.lrgAssump2.setToolTipText("Exchangable");
                this.lrgAssump2.setSize(27, 27);
            }
        } else if (string == "Add") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.outcomes.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove") {
            Object[] objectArray = this.outcomes.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.outcomes.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "Add Factor") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            if (objectArray.length > 1) {
                this.variableSelector.getJList().setSelectedIndex(this.variableSelector.getJList().getSelectedIndex());
            } else if (objectArray.length == 1 && this.factor.getModel().getSize() == 0) {
                this.variableSelector.remove(objectArray[0]);
                ((DefaultListModel)this.factor.getModel()).addElement(objectArray[0]);
            }
        } else if (string == "Remove Factor") {
            DefaultListModel defaultListModel = (DefaultListModel)this.factor.getModel();
            if (defaultListModel.getSize() > 0) {
                this.variableSelector.add(defaultListModel.remove(0));
            }
        } else if (string == "comboBoxChanged") {
            this.setModel(new TwoSampleModel());
        } else if (string == "Plots") {
            KSamplePlots kSamplePlots = new KSamplePlots(this, this.testModel.plots);
            kSamplePlots.setLocationRelativeTo(this);
            kSamplePlots.setVisible(true);
        }
    }
}

