/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import org.rosuda.ibase.Common;
import org.rosuda.util.Tools;

public class ColorBridge {
    Color[] basicCol = new Color[128];
    String[] name = new String[128];
    static final String[] CBset1 = new String[]{"#EF7677", "#87B2D4", "#FFB266", "#C195C8", "#94CF92", "#FFFF85", "#CA9A7E", "#FAB3D9", "#C2C2C2"};
    protected static ColorBridge main;

    public ColorBridge() {
        this.basicCol[0] = new Color(255, 255, 255);
        this.name[0] = "white";
        this.basicCol[1] = new Color(0, 0, 0);
        this.name[1] = "black";
        this.basicCol[2] = new Color(255, 0, 0);
        this.name[2] = "red";
        this.basicCol[3] = new Color(0, 205, 0);
        this.name[3] = "green";
        this.basicCol[4] = new Color(0, 0, 255);
        this.name[4] = "blue";
        this.basicCol[5] = new Color(0, 255, 255);
        this.basicCol[6] = new Color(255, 0, 255);
        this.basicCol[7] = new Color(255, 255, 0);
        this.name[7] = "yellow";
        this.basicCol[8] = new Color(190, 190, 190);
        for (int i = 0; i < CBset1.length; ++i) {
            this.basicCol[16 + i] = Tools.hrgb2color(CBset1[i]);
        }
        this.setHCLParameters(55.0, 75.0);
    }

    public void setHCLParameters(double d, double d2) {
        for (int i = 0; i < 64; ++i) {
            this.basicCol[i + 64] = Common.getHCLcolor((double)i * 360.0 / 64.0, d, d2);
        }
    }

    public static ColorBridge getMain() {
        if (main == null) {
            main = new ColorBridge();
        }
        return main;
    }

    public Color getColor(int n) {
        return this.basicCol[n == 0 ? 0 : (n - 1 & 0x7F) + 1];
    }

    public Color getColor(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return new Color((int)(d * 255.0 + 0.5), (int)(d * 255.0 + 0.5), (int)(d * 255.0 + 0.5));
    }

    public Color getColor(String string) {
        for (int i = 0; i < 9; ++i) {
            if (this.name[i] == null || !string.equals(this.name[i])) continue;
            return this.basicCol[i];
        }
        return this.basicCol[1];
    }
}

