/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.PlotBuilder;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.SideWindow;

public class PlotBuilderSubFrame
extends SideWindow
implements ActionListener {
    private JPanel panel;
    private OkayCancelPanel okayCancel;
    private JPanel elementView;
    private PlottingElement element;
    private ElementModel initialModel;
    private HelpButton help;

    public PlotBuilderSubFrame(Window window) {
        super(window);
        this.initGUI();
        this.updateLocation();
        this.updateSize();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(923, 92, 6, 12, 0, 0, 2, 2));
            this.help.setPreferredSize(new Dimension(36, 36));
            this.okayCancel = new OkayCancelPanel(true, false, this);
            this.getContentPane().add((Component)this.okayCancel, new AnchorConstraint(929, 17, 6, 504, 0, 2, 2, 0));
            this.okayCancel.setPreferredSize(new Dimension(240, 38));
            this.okayCancel.getCancelButton().setText("Apply");
            this.okayCancel.getResetButton().setText("Cancel");
            this.pack();
            this.setSize(455, 554);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.okayCancel.addActionListener(actionListener);
    }

    public void removeAllActionListeners() {
        this.okayCancel.removeAllActionListeners();
    }

    public void setElement(PlottingElement plottingElement) {
        if (this.elementView != null) {
            this.getContentPane().remove(this.elementView);
        }
        this.elementView = plottingElement.getPanel();
        this.element = plottingElement;
        this.initialModel = (ElementModel)plottingElement.getModel().clone();
        this.getContentPane().add((Component)this.elementView, new AnchorConstraint(0, 1001, 44, 1, 1, 1, 2, 1));
        this.help.setUrl(this.element.getUrl());
        this.help.setToolTipText("Open online help from: " + this.element.getUrl());
    }

    public void setToInitialModel() {
        this.element.setModel(this.initialModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK" || string == "Apply") {
            try {
                ElementView elementView = (ElementView)this.elementView;
                ElementModel elementModel = elementView.getModel();
                String string2 = elementModel.checkValid();
                if (string2 != null) {
                    JOptionPane.showMessageDialog(this, string2);
                    return;
                }
                if (string == "OK") {
                    this.setVisible(false);
                }
                this.initialModel = (ElementModel)this.element.getModel().clone();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((PlotBuilder)((Object)this.parent)).updatePlot();
        } else {
            this.setToInitialModel();
            this.setVisible(false);
        }
    }
}

