/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.FixedColumnTable;
import edu.cens.text.RObjectChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.HelpButton;

public class DocumentTermMatrixViewer
extends JDialog {
    private JTable table;
    private RObjectChooser corpusChooser;
    final JScrollPane scrollPane;
    private static final int FREQ_COLUMN_WIDTH = 50;
    FixedColumnTable fixedTable;
    private static final String HELP_URL = "index.php?n=Main.TextTermDocumentMatrix";

    public DocumentTermMatrixViewer(Frame frame) {
        super(frame);
        this.setTitle("Term Document Matrix Viewer");
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.doTableSetup();
        this.initTableDebug();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getTopLevelConstraints();
        this.scrollPane.setAutoscrolls(true);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.corpusChooser = new RObjectChooser();
        this.corpusChooser.setClassFilter("Corpus");
        this.corpusChooser.refreshObjects();
        this.corpusChooser.getComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DocumentTermMatrixViewer.this.corpusChooser.getSelectedObject();
                DocumentTermMatrixViewer.this.initTableFromCorpus(string);
                DocumentTermMatrixViewer.this.adjustForTableSize();
            }
        });
        if (this.corpusChooser.getItemCount() > 0) {
            this.corpusChooser.setSelectedIndex(0);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.corpusChooser, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        jPanel.add((Component)new HelpButton(HELP_URL), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel("Terms:");
        jLabel.setPreferredSize(new Dimension(120, jLabel.getPreferredSize().height));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)new JLabel("Documents:"), gridBagConstraints);
        gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = this.getTopLevelConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 15, 15);
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    public void doTableSetup() {
        this.table.setAutoResizeMode(0);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.getTableHeader().setReorderingAllowed(false);
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(50);
        }
        if (this.table.getColumnCount() > 0) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(115);
            this.table.getColumnModel().getColumn(0).setMaxWidth(175);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(75);
            this.table.getColumnModel().getColumn(1).setMaxWidth(75);
            this.scrollPane.setViewportView(this.table);
            this.fixedTable = new FixedColumnTable(2, this.scrollPane);
            this.fixedTable.getFixedTable().setShowGrid(true);
            this.fixedTable.getFixedTable().setGridColor(Color.LIGHT_GRAY);
        }
    }

    public void initTableFromCorpus(String string) {
        try {
            this.table = new JTable();
            String string2 = Deducer.getUniqueName((String)"dtm");
            Deducer.eval((String)(string2 + " <- TermDocumentMatrix(" + string + ", control = list(tolower=FALSE, minWordLength=1))"));
            Deducer.eval((String)(string2 + "<- " + string2 + "[order(apply(" + string2 + " > 0, 1, sum), rev(" + string2 + "$dimnames$Terms), decreasing=TRUE),]"));
            final String[] stringArray = Deducer.eval((String)(string2 + "$dimnames$Terms")).asStrings();
            final String[] stringArray2 = Deducer.eval((String)(string2 + "$dimnames$Docs")).asStrings();
            int[] nArray = Deducer.eval((String)(string2 + "$i")).asIntegers();
            int[] nArray2 = Deducer.eval((String)(string2 + "$j")).asIntegers();
            int[] nArray3 = Deducer.eval((String)(string2 + "$v")).asIntegers();
            final int[] nArray4 = Deducer.eval((String)("unname(apply(" + string2 + ",1,sum))")).asIntegers();
            final HashMap<Point, Integer> hashMap = new HashMap<Point, Integer>();
            for (int i = 0; i < nArray.length; ++i) {
                hashMap.put(new Point(nArray[i] - 1, nArray2[i] - 1), nArray3[i]);
            }
            this.table.setModel(new AbstractTableModel(){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                public Object getValueAt(int n, int n2) {
                    if (n2 == 0) {
                        return stringArray[n];
                    }
                    if (n2 == 1) {
                        return nArray4[n];
                    }
                    return hashMap.get(new Point(n, n2 - 2));
                }

                public int getRowCount() {
                    return stringArray.length;
                }

                public String getColumnName(int n) {
                    if (n == 0) {
                        return "Terms";
                    }
                    if (n == 1) {
                        return "Total";
                    }
                    return n - 1 + "";
                }

                public int getColumnCount() {
                    return stringArray2.length + 2;
                }
            });
            this.doTableSetup();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            rEXPMismatchException.printStackTrace();
        }
    }

    public void initTableDebug() {
        this.table = new JTable();
        final String[] stringArray = new String[]{"ergot", "escargot", "excommunicate"};
        final String[] stringArray2 = new String[]{"a", "modest", "proposal"};
        int n = stringArray.length;
        int[] nArray = new int[]{1, 2, 2};
        int[] nArray2 = new int[]{1, 2, 1};
        int[] nArray3 = new int[]{1000, 2000, 501};
        final HashMap<Point, Integer> hashMap = new HashMap<Point, Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            hashMap.put(new Point(nArray[i] - 1, nArray2[i] - 1), nArray3[i]);
        }
        this.table.setModel(new AbstractTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return stringArray[n];
                }
                if (n2 == 1) {
                    return 101;
                }
                return hashMap.get(new Point(n, n2 - 1));
            }

            public int getRowCount() {
                return stringArray.length;
            }

            public String getColumnName(int n) {
                if (n == 0) {
                    return "Terms";
                }
                return n + "";
            }

            public int getColumnCount() {
                return stringArray2.length + 2;
            }
        });
        this.doTableSetup();
    }

    public void adjustForTableSize() {
        this.table.setPreferredScrollableViewportSize(new Dimension(Math.min(500, this.table.getPreferredSize().width), Math.min(400, this.table.getPreferredSize().height)));
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    public GridBagConstraints getTopLevelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        return gridBagConstraints;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.adjustForTableSize();
        }
        super.setVisible(bl);
    }

    public static void main(String[] stringArray) {
        DocumentTermMatrixViewer documentTermMatrixViewer = new DocumentTermMatrixViewer(null);
        documentTermMatrixViewer.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        documentTermMatrixViewer.setVisible(true);
        documentTermMatrixViewer.requestFocus();
    }
}

