% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cswi.aSE.R
\name{cswi.aSE}
\alias{cswi.aSE}
\title{Within-group synchrony for homoscedastic compound symmetry model}
\usage{
cswi.aSE(model)
}
\arguments{
\item{model}{a class "\code{lme}" compound symmetry model (\code{mCS}) produced by \code{\link{dendro.varcov}} with \code{homoscedastic} equals \code{TRUE}.}
}
\value{
The function returns a \code{matrix} containing within-group synchrony and SE for each combinations of \code{varGroup} levels. This function is used internally in \code{\link{sync}}.
}
\description{
The function calculates the within-group synchrony (a^) and standard error (SE) for homoscedastic compound symmetry models (mCS).
}
\details{
The function calculates within-group synchrony for homoscedastic compound symmetry model (mCS).
}
\examples{
## Calculate within-group homoscedastic synchrony and SE
 # for compound symmetry homocedastic model of conifersIP data:
 data(conifersIP)
 
 #Fit the homoscedastic set of varcov models (mBE, mNE, mCS, mUN)
 # using taxonomic grouping criteria (ie. Species)
 ModHm <- dendro.varcov(TRW ~ Code, varTime = "Year", varGroup = "Species", 
                        data = conifersIP, homoscedastic = TRUE)
 summary(ModHm)
   
 #Obtain the compound symmetry model within-group synchrony and SE
 # for each varGroup stratum.
 cswi.aSE(ModHm$mCS)#compound symmetry
   
}
\references{
Shestakova, T.A., Aguilera, M., Ferrio, J.P., Gutierrez, E. & Voltas, J. (2014). Unravelling spatiotemporal tree-ring signals in Mediterranean oaks: a variance-covariance modelling approach of carbon and oxygen isotope ratios. \emph{Tree Physiology} 34: 819-838.

Shestakova, T.A., Gutierrez, E., Kirdyanov, A.V., Camarero, J.J., Genova, M., Knorre, A.A., Linares, J.C., Resco de Dios, V., Sanchez-Salguero, R. & Voltas, J. (2016). Forests synchronize their growth in contrasting Eurasian regions in response to climate warming. \emph{Proceedings of the National Academy of Sciences of the United States of America} 113: 662-667.
}
\seealso{
\code{\link{sync}} for a clear description of synchrony evaluation.
}
\author{
Josu G. Alday, Tatiana A. Shestakova, Victor Resco de Dios, Jordi Voltas
}
