% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.trend.plot.R
\name{sync.trend.plot}
\alias{sync.trend.plot}
\title{Plot temporal trends of synchrony}
\usage{
sync.trend.plot (sync.trend.data)
}
\arguments{
\item{sync.trend.data}{a \code{data.frame} of the type as produced by \code{\link{sync.trend}}.}
}
\value{
Line chart
}
\description{
The function creates a line chart showing temporal trends of spatial synchrony from \code{data.frame} of the type as produced by \code{\link{sync.trend}}.
}
\details{
The function makes a line chart showing synchrony trends across years from a data.frame produced by \code{\link{sync.trend}}. Within- or between- group synchrony and SE are indicated for a selected time window. If synchrony is defined using using \code{null.mod = TRUE} (\code{\link{sync.trend}}) only general synchrony is ploted. If synchrony is defined using using \code{null.mod = FALSE} (\code{\link{sync.trend}}) different synchronies for each group variable (\code{varGroup}) are fitted with different colours for each stratum.
}
\examples{
## Calculate temporal trends of synchrony for conifersIP data:
 data(conifersIP)
 
 ##Fit the null.model temporal trend (mBE) using taxonomic grouping criteria (i.e. Species)
 mBE.trend <- sync.trend(TRW ~ Code, varTime = "Year", varGroup = "Species", 
                          data = conifersIP, null.mod = TRUE, window = 30, lag = 5)
 
 mBE.trend# it returns a data.frame
 sync.trend.plot(mBE.trend)# Broad evaluation synchrony linechart

\dontrun{ 
 ##Fit homoscedastic within-group trends (mBE, mNE, mCS, mUN) 
 # using geographic grouping criteria (i.e. Region)
 geo.trend <- sync.trend(TRW ~ Code, varTime = "Year", varGroup = "Region", 
                         data = conifersIP, window = 30, lag = 5, 
                         null.mod = FALSE, homoscedastic = TRUE)
 
 geo.trend#a data.frame with varGroup synchrony for each time window.
 sync.trend.plot(geo.trend)#Selected heteroscedastic between-group trends by AIC
 
 ##Fit heteroscedastic betwen-group trends (mBE, mHeNE, mHeCS, mHeUN) 
 # using geographic grouping criteria (i.e. Region) and AICc
 geo.het.trend <- sync.trend(TRW ~ Code, varTime = "Year", varGroup = "Region", 
                    data = conifersIP, window = 30, lag = 5, null.mod = FALSE, 
                    selection.method = c("AICc"), homoscedastic = FALSE, between.group = TRUE)
 
 geo.het.trend
 sync.trend.plot(geo.het.trend)#Selected heteroscedastic between-group trends by AICc
 
 ##Fit homoscedastic and heteroscedastic within-group trends 
 # using taxonomic grouping criteria (i.e. Species) and BIC
 geo.tot.trend <- sync.trend(TRW ~ Code, varTime = "Year", varGroup = "Species", 
                    data = conifersIP, window = 30, lag = 5, selection.method = c("BIC"),
                    null.mod = F, all.mod = TRUE)
 geo.tot.trend
 #Selected homoscedastic and heteroscedastic within-group trends by BIC
 sync.trend.plot(geo.tot.trend)
 }
 

}
\author{
Josu G. Alday, Tatiana A. Shestakova, Victor Resco de Dios, Jordi Voltas
}
