% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{partition}
\alias{partition}
\title{Paritions data by most inter-dependent positions}
\usage{
partition(
  data,
  minElements = 10,
  threshold = 0.1,
  numBestForSorting = 3,
  maxNum = 6,
  sortByWeights = NULL,
  partition.by = NULL
)
}
\arguments{
\item{data}{the data as \link{DLData} object}

\item{minElements}{the minimum number of elements to perform a further split}

\item{threshold}{the threshold on the average mutual information value}

\item{numBestForSorting}{the number of dependencies to other positions
considered}

\item{maxNum}{the maximum number of recursive splits}

\item{sortByWeights}{if \code{TRUE}, partitions are ordered by their average
weight value, if \code{false} by frequency of symbols at the partitioning
position otherwise. If \code{NULL}, the \code{$sortByWeights} value of the
\link{DLData} object is used}

\item{partition.by}{specify fixed positions to partition by}
}
\value{
the partitions as list of \link{DLData} objects
}
\description{
Partitions \code{data} by the nucleotides at the most inter-dependent
positions as measures by pairwise mutual information. Paritioning is
performed recursively on the resulting subsets until i) the number of
sequences in a partition is less then \code{minElements}, ii) the average
pairwise dependency between the current position and \code{numBestForSorting}
other positions with the largest mutual information value drops below
\code{threshold}, or iii) \code{maxNum} recursive splits have already been
performed. If splitting results in smaller partitions than
\code{minElements}, these are added to the smallest partition with more than
\code{minElements} sequences.
}
\examples{
# create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"),
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1], weights = log1p(seqs[,2]) )

# partition data using default parameters
partitions <- partition(data)

# partition data using a threshold of 0.3 on the mutual 
# information value to the most dependent position, 
# sorting the resulting partitions by weight
partitions2 <- partition(data = data, threshold = 0.3, numBestForSorting = 1, sortByWeights = TRUE)
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
