% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCo_per_iter.R
\name{DiSCo_per_iter}
\alias{DiSCo_per_iter}
\title{DiSCo_per_iter}
\usage{
DiSCo_per_iter(
  c_df,
  c_df.q,
  t_df,
  T0,
  peridx,
  evgrid,
  idx,
  grid_df,
  M = 1000,
  ww = 0,
  qmethod = NULL,
  qtype = 7,
  q_min = 0,
  q_max = 1,
  simplex = FALSE,
  mixture = FALSE
)
}
\arguments{
\item{c_df}{List of control units}

\item{c_df.q}{List of quantiles of control units}

\item{t_df}{List of target unit}

\item{idx}{Index of permuted target unit}

\item{grid_df}{Grids to evaluate CDFs on, only needed when \code{mixture=TRUE}}

\item{M}{Integer indicating the number of control quantiles to use in the DiSCo method. Default is 1000.}

\item{qmethod}{Character, indicating the method to use for computing the quantiles of the target distribution. The default is NULL, which uses the \code{\link[stats]{quantile}} function from the stats package.
Other options are "\code{\link[evmix]{qkden}}" (based on smoothed kernel density function) and "\code{\link[extremeStat:distLquantile]{extreme}}" (based on parametric extreme value distributions).
Both are substantially slower than the default method but may be useful for fat-tailed distributions with few data points at the upper quantiles. Alternatively, one could use the q_max option to restrict the range of quantiles used.}

\item{qtype}{Integer, indicating the type of quantile to compute when using  \code{\link[stats]{quantile}} in the \code{qmethod} argument.
The default 7. See the documentation for the \code{\link[stats]{quantile}} function for more information.}

\item{q_min}{Numeric, minimum quantile to use. Set this together with \code{q_max} to restrict the range of quantiles used to construct the synthetic control.
Default is 0 (all quantiles). Currently NOT implemented for the \code{mixture} approach.}

\item{q_max}{Numeric, maximum quantile to use. Set this together with \code{q_min} to restrict the range of quantiles used to construct the synthetic control.
Default is 1 (all quantiles). Currently NOT implemented for the \code{mixture} approach.}

\item{simplex}{Logical, indicating whether to use to constrain the optimal weights to the unit simplex. Default is FALSE, which only constrains the weights to sum up to 1 but allows them to be negative.}

\item{mixture}{Logical, indicating whether to use the mixture of distributions approach instead.
See Section 4.3. in \insertCite{gunsilius2023distributional;textual}{DiSCos}. This approach minimizes the distance between the CDFs
instead of the quantile functions, and is preferred for categorical variables. When working with such variables, one should
also provide a list of support points in the \code{grid.cat} parameter. When that is provided, this parameter is automatically set to TRUE. Default is FALSE.}
}
\value{
List of squared Wasserstein distances between the target unit and the control units
}
\description{
This function performs one iteration of the permutation test
}
\keyword{internal}
