print.diag <- function(x,...){
  #options(digits=4)
  cat("\n\n")
  print(x$tabmarg)
  cat("\n\n")
  cat("The test has the following parameters [",paste(x$Conf.limit*100),"% confidence interval]\n")
  cat("---------------------------------------------------------------\n")
  cat("Sample size:                ",x$n,"\n")
  cat("Prevalence considered:      ",paste(round(x$p*100,digits=2)),"%\n")
  cat("Sensitivity:                ",paste(round(x$Se*100,digits=2)),"% [",paste(round(x$Se.cl[1]*100,digits=2))," - ",paste(round(x$Se.cl[2]*100,digits=2)),"]\n")
  cat("Specificity:                ",paste(round(x$Sp*100,digits=2)),"% [",paste(round(x$Sp.cl[1]*100,digits=2))," - ",paste(round(x$Sp.cl[2]*100,digits=2)),"]\n")
  cat("Positive predictive value:  ",paste(round(x$PPV*100,digits=2)),"% [",paste(round(x$PPV.cl[1]*100,digits=2))," - ",paste(round(x$PPV.cl[2]*100,digits=2)),"]\n")
  cat("Negative predictive value:  ",paste(round(x$NPV*100,digits=2)),"% [",paste(round(x$NPV.cl[1]*100,digits=2))," - ",paste(round(x$NPV.cl[2]*100,digits=2)),"]\n")
  cat("Positive likelihood ratio:  ",paste(round(x$PLR,digits=2)),"  [",paste(round(x$PLR.inf.cl,digits=2))," - ",paste(round(x$PLR.sup.cl,digits=2)),"]\n")
  cat("Negative likelihood ratio:  ",paste(round(x$NLR,digits=2)),"   [",paste(round(x$NLR.inf.cl,digits=2))," - ",paste(round(x$NLR.sup.cl,digits=2)),"]\n")
  cat("Diagnostic odds ratio:      ",paste(round(x$DOR,digits=2))," [",paste(round(x$DOR.inf.cl,digits=2))," - ",paste(round(x$DOR.sup.cl,digits=2)),"]\n")
  cat("Error trade off (FN : FP)   ",paste(round(x$ET,digits=2))," : 1 \n")
  cat("Error rate:                 ",paste(round(x$ER*100,digits=2)),"% [",paste(round(x$ER.cl[1]*100,digits=2))," - ",paste(round(x$ER.cl[2]*100,digits=2)),"]\n")
  cat("Accuracy:                   ",paste(round(x$accu*100,digits=2)),"% [",paste(round(x$accu.cl[1]*100,digits=2))," - ",paste(round(x$accu.cl[2]*100,digits=2)),"]\n")
  cat("Youden index:               ",paste(round(x$Youden,digits=4))," [",paste(round(x$Youden.inf.cl,digits=4))," - ",paste(round(x$Youden.sup.cl,digits=4)),"]\n")
  cat("Area under ROC curve:       ",paste(round(x$AUC,digits=4)),"\n")
  cat("---------------------------------------------------------------\n")
  #options(digits=7)
}
