% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_nodes.R
\name{get_nodes}
\alias{get_nodes}
\title{Get vector of node IDs}
\usage{
get_nodes(...)
}
\arguments{
\item{...}{a collection of node data frames, edge data frames, or a single graph object.}
}
\value{
a vector of node ID values.
}
\description{
Provides information on the node IDs from one or several node data frames, edge data frames, or graph objects.
}
\examples{
\dontrun{
# Before getting node ID values, create a simple graph
nodes <-
  create_nodes(nodes = LETTERS,
               label = TRUE,
               type = c(rep("a_to_g", 7),
                        rep("h_to_p", 9),
                        rep("q_to_x", 8),
                        rep("y_and_z",2)))

edges <-
  create_edges(from = sample(LETTERS, replace = TRUE),
               to = sample(LETTERS, replace = TRUE),
               label = "edge",
               relationship = "letter_to_letter")

graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges,
               graph_attrs = "layout = neato",
               node_attrs = c("fontname = Helvetica",
                              "shape = circle"))

# Get a vector of all nodes in a graph
get_nodes(graph)
#> [1] "A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L"
#> [13] "M" "N" "O" "P" "Q" "R" "S" "T" "U" "V" "W" "X"
#> [25] "Y" "Z"

# Get a vector of node ID values from a node data frame
get_nodes(nodes)
#> [1] "A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L"
#> [13] "M" "N" "O" "P" "Q" "R" "S" "T" "U" "V" "W" "X"
#> [25] "Y" "Z"

# Get a vector of node ID values from an edge data frame
get_nodes(edges)
#> [1] "A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L"
#> [13] "M" "N" "O" "P" "Q" "R" "S" "T" "U" "V" "W" "X"
#> [25] "Y" "Z"
}
}

